/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.item.tools;

import io.github.foundationgames.splinecart.block.TrackMarkerBlockEntity;
import io.github.foundationgames.splinecart.item.tools.ToolItem;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

public class OrientationToolItem
extends ToolItem {
    public final Type type;
    public static final int STEP = 90;

    public OrientationToolItem(Type type, String identifier, class_5321<class_1792> registryKey) {
        super(identifier, registryKey);
        this.type = type;
    }

    @Override
    public boolean use(TrackMarkerBlockEntity marker, class_1657 player, class_1937 world, boolean rightClick) {
        int clickResolution = player.method_5715() ? 5 : 45;
        int value = this.getValueForTool(marker);
        int newVal = (value + ((rightClick ? clickResolution : -clickResolution) + 360)) % 360;
        this.setValueForTool(marker, newVal);
        marker.updatePose();
        marker.sync();
        marker.method_5431();
        return true;
    }

    private int getValueForTool(TrackMarkerBlockEntity marker) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> marker.heading;
            case 1 -> marker.pitching;
            case 2 -> marker.banking;
            case 3 -> marker.relative_orientation;
        };
    }

    private void setValueForTool(TrackMarkerBlockEntity marker, int value) {
        switch (this.type.ordinal()) {
            case 0: {
                marker.heading = value;
                break;
            }
            case 1: {
                marker.pitching = value;
                break;
            }
            case 2: {
                marker.banking = value;
                break;
            }
            case 3: {
                marker.relative_orientation = value;
            }
        }
    }

    @Override
    protected String writeCurrentState(TrackMarkerBlockEntity marker) {
        int value = this.getValueForTool(marker);
        return this.type == Type.HEADING ? OrientationToolItem.valToQuarterDirection(value) + " (" + value + ")" : OrientationToolItem.valToOrientation(value);
    }

    @Override
    protected int getTextColor() {
        return this.type.color;
    }

    private static String valToOrientation(int val) {
        if (val == 0) {
            return "0";
        }
        if (val <= 180) {
            return val + "\u00b0";
        }
        return "-" + (360 - val) + "\u00b0";
    }

    private static String valToQuarterDirection(int val) {
        for (QuarterDirection direction : QuarterDirection.values()) {
            if (val == direction.value) {
                return direction.name;
            }
            if (val <= direction.value || val >= direction.value + 90) continue;
            int relativeDirection = val - direction.value;
            if (relativeDirection == 45) {
                return direction.compiledName;
            }
            return direction.compiledName + " " + relativeDirection + "\u00b0";
        }
        return "ERROR";
    }

    public static enum Type {
        HEADING(-16711936),
        PITCHING(-11010079),
        BANKING(-256),
        RELATIVE_ORIENTATION(-65536);

        final int color;

        private Type(int color) {
            this.color = color;
        }
    }

    public static enum QuarterDirection {
        SOUTH(0, "S", "SE"),
        EAST(90, "E", "NE"),
        NORTH(180, "N", "NW"),
        WEST(270, "W", "SW");

        public final int value;
        public final String name;
        public final String compiledName;

        private QuarterDirection(int value, String name, String compiledName) {
            this.value = value;
            this.name = name;
            this.compiledName = compiledName;
        }
    }
}

