/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.item.tools;

import io.github.foundationgames.splinecart.block.TrackMarkerBlockEntity;
import io.github.foundationgames.splinecart.item.tools.ToolItem;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

public class PowerToolItem
extends ToolItem {
    private static final int LOW_INCREMENT = 5;
    private static final int HIGH_INCREMENT = 100;
    public final Type type;

    public PowerToolItem(Type type, String identifier, class_5321<class_1792> registryKey) {
        super(identifier, registryKey);
        this.type = type;
    }

    @Override
    public boolean use(TrackMarkerBlockEntity marker, class_1657 player, class_1937 world, boolean rightClick) {
        int newValue;
        int oldValue = this.getValueForTool(marker);
        if (oldValue == Integer.MAX_VALUE) {
            newValue = rightClick ? 0 : (player.method_5715() ? -5 : -100);
        } else {
            newValue = oldValue + (rightClick ? 1 : -1) * (player.method_5715() ? 5 : 100);
            if (oldValue < 0 && newValue >= 0 || oldValue >= 0 && newValue < 0) {
                newValue = Integer.MAX_VALUE;
            }
        }
        this.setValueForTool(marker, newValue);
        marker.method_5431();
        marker.sync();
        return true;
    }

    private int getValueForTool(TrackMarkerBlockEntity marker) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> marker.getPower();
            case 1 -> marker.getStrength();
        };
    }

    private void setValueForTool(TrackMarkerBlockEntity marker, int value) {
        switch (this.type.ordinal()) {
            case 0: {
                marker.setPower(value);
                break;
            }
            case 1: {
                marker.setStrength(value);
            }
        }
    }

    @Override
    protected String writeCurrentState(TrackMarkerBlockEntity marker) {
        return this.getValueForTool(marker) == Integer.MAX_VALUE ? "Unset" : PowerToolItem.toFixedPointRepresentation(this.getValueForTool(marker));
    }

    @Override
    protected int getTextColor() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> -2142128;
            case 1 -> -16776961;
        };
    }

    public static String toFixedPointRepresentation(int val) {
        return val / 10 + "." + Math.abs(val % 10);
    }

    public static enum Type {
        POWER,
        STRENGTH;

    }
}

