/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.item.tools;

import io.github.foundationgames.splinecart.block.TrackMarkerBlockEntity;
import io.github.foundationgames.splinecart.item.tools.ToolItem;
import io.github.foundationgames.splinecart.track.TrackStyle;
import io.github.foundationgames.splinecart.track.TrackType;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

public class TrackToolItem
extends ToolItem {
    public final Type type;

    public TrackToolItem(Type type, String identifier, class_5321<class_1792> registryKey) {
        super(identifier, registryKey);
        this.type = type;
    }

    @Override
    public boolean use(TrackMarkerBlockEntity marker, class_1657 player, class_1937 world, boolean rightClick) {
        int oldValue = this.getValueForTool(marker);
        int newValue = (oldValue + (rightClick ? 1 : -1) + this.type.settings) % this.type.settings;
        do {
            this.setValueForTool(marker, newValue);
            marker.method_5431();
            marker.sync();
            marker = marker.getNextMarker();
        } while (player.method_5715() && marker != null && this.getValueForTool(marker) == oldValue);
        return true;
    }

    private int getValueForTool(TrackMarkerBlockEntity marker) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> marker.nextStyle.ordinal();
            case 1 -> marker.nextType.ordinal();
        };
    }

    private void setValueForTool(TrackMarkerBlockEntity marker, int value) {
        switch (this.type.ordinal()) {
            case 0: {
                marker.nextStyle = TrackStyle.read(value);
                break;
            }
            case 1: {
                marker.nextType = TrackType.read(value);
            }
        }
    }

    @Override
    protected String writeCurrentState(TrackMarkerBlockEntity marker) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> marker.nextStyle.name;
            case 1 -> marker.nextType.name;
        };
    }

    public static enum Type {
        STYLE(8),
        TYPE(3);

        public final int settings;

        private Type(int settings) {
            this.settings = settings;
        }
    }
}

