/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.item.tools;

import io.github.foundationgames.splinecart.block.TrackMarkerBlockEntity;
import io.github.foundationgames.splinecart.block.TrackMarkerTrigger;
import io.github.foundationgames.splinecart.block.TrackMarkerTriggers;
import io.github.foundationgames.splinecart.item.tools.ToolItem;
import io.github.foundationgames.splinecart.mixin_interface.PlayerMixinInterface;
import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_5321;

public class TriggerTool
extends ToolItem {
    public TriggerTool(String identifier, class_5321<class_1792> registryKey) {
        super(identifier, registryKey);
    }

    @Override
    protected class_2561 getCurrentStateMessage(TrackMarkerBlockEntity marker) {
        if (marker.triggers.triggers.isEmpty()) {
            return class_2561.method_30163((String)"No triggers saved");
        }
        StringBuilder msg = new StringBuilder();
        ArrayList<TrackMarkerTrigger> triggers = marker.triggers.triggers;
        for (int i = 0; i < triggers.size(); ++i) {
            if (i != 0) {
                msg.append("      ");
            }
            msg.append(triggers.get(i).getDisplayString("(%d, %d, %d) p: %s s: %s"));
        }
        return class_2561.method_30163((String)msg.toString());
    }

    @Override
    public boolean use(TrackMarkerBlockEntity marker, class_1657 playerEntity, class_1937 world, boolean rightClick) {
        class_2586 class_25862;
        PlayerMixinInterface player = (PlayerMixinInterface)playerEntity;
        if (!rightClick) {
            return this.selectTrigger(player, playerEntity, marker.method_11016());
        }
        if (playerEntity.method_5715()) {
            return this.removeAllTriggers(playerEntity, marker);
        }
        if (player.getSelectedTrigger() == null || !((class_25862 = world.method_8321(player.getSelectedTrigger())) instanceof TrackMarkerBlockEntity)) {
            return false;
        }
        TrackMarkerBlockEntity savedMarker = (TrackMarkerBlockEntity)class_25862;
        return this.addTrigger(playerEntity, marker, savedMarker);
    }

    private boolean selectTrigger(PlayerMixinInterface player, class_1657 playerEntity, class_2338 pos) {
        if (pos.equals((Object)player.getSelectedTrigger())) {
            return false;
        }
        player.setSelectedTrigger(pos);
        TriggerTool.sendChatMessage(playerEntity, "Selected marker " + pos.method_23854());
        return true;
    }

    private boolean removeAllTriggers(class_1657 playerEntity, TrackMarkerBlockEntity marker) {
        if (marker.triggers.triggers.isEmpty()) {
            return false;
        }
        marker.triggers = new TrackMarkerTriggers();
        marker.method_5431();
        TriggerTool.sendChatMessage(playerEntity, "Removed all triggers.");
        return true;
    }

    private boolean addTrigger(class_1657 playerEntity, TrackMarkerBlockEntity marker, TrackMarkerBlockEntity savedMarker) {
        TrackMarkerTrigger trigger = new TrackMarkerTrigger(savedMarker);
        if (marker.triggers.contains(trigger)) {
            return false;
        }
        marker.triggers.containsPos(trigger.getLocation()).ifPresent(duplicate -> marker.triggers.triggers.remove(duplicate));
        marker.triggers.triggers.add(trigger);
        marker.method_5431();
        TriggerTool.sendChatMessage(playerEntity, "Added new Trigger: " + trigger.getDisplayString("(%d, %d, %d) power: %s setting: %s"));
        return true;
    }

    private static void sendChatMessage(class_1657 player, String text) {
        if (player.method_37908().field_9236) {
            player.method_7353(class_2561.method_30163((String)text), false);
        }
    }

    @Override
    protected String writeCurrentState(TrackMarkerBlockEntity marker) {
        return "";
    }
}

