/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.track;

import org.joml.Vector3f;

public record TrackColor(int hex) {
    public float getR() {
        return (float)((this.hex & 0xFF0000) >> 16) / 255.0f;
    }

    public float getG() {
        return (float)((this.hex & 0xFF00) >> 8) / 255.0f;
    }

    public float getB() {
        return (float)(this.hex & 0xFF) / 255.0f;
    }

    public Vector3f getVec3f() {
        return new Vector3f(this.getR(), this.getG(), this.getB());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TrackColor)) return false;
        TrackColor trackColor = (TrackColor)obj;
        try {
            int n;
            int other = n = trackColor.hex();
            if (this.hex != other) return false;
            return true;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

