/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.track;

import io.github.foundationgames.splinecart.util.SUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public enum TrackType {
    DEFAULT(MotionModifier.FRICTION, null, "Default"),
    CHAIN_DRIVE((m, g, p, s, f) -> {
        double chainliftSpeed = p * 0.1 / 72.0;
        double frictionSpeed = MotionModifier.FRICTION.calculate(m, g, p, s, f);
        return s == 0.0 ? frictionSpeed : (chainliftSpeed >= 0.0 ? Math.max(frictionSpeed, chainliftSpeed) : Math.min(frictionSpeed, chainliftSpeed));
    }, (p, t, col, v) -> {
        v[0] = t * 4.0E-4f * (float)p;
    }, "Chain Drive"),
    MAGNETIC((m, g, p, s, f) -> {
        double targetSpeed = p / 10.0 / 72.0;
        return Math.abs(targetSpeed - m) < 0.01 ? targetSpeed : m + (double)(targetSpeed < m ? -1 : 1) * 0.0025 * s / 10.0;
    }, (p, t, col, v) -> {
        int absSpeed = Math.abs(p / 10);
        col.set((Vector3fc)SUtil.REDSTONE_COLOR_LUT[Math.min(absSpeed, 15)]);
    }, "Magnetic"),
    TIRE_DRIVE((m, g, p, s, f) -> p / 10.0 / 72.0, (p, t, col, v) -> {
        v[0] = t * ((float)p / 15.0f * 0.05f);
    }, "Tire Drive"),
    HOLDING_BREAKS((m, g, p, s, f) -> p > 0.0 ? MotionModifier.FRICTION.calculate(m, g, p, s, f) : 0.0, (p, t, col, v) -> {
        v[0] = t * ((float)p / 15.0f * 0.05f);
    }, "Holding Breaks");

    public static final int CANVAS_SIZE = 4;
    public static final float INVERSE_CANVAS_SIZE = 0.25f;
    public final MotionModifier motion;
    @Nullable
    public final Overlay overlay;
    public final String name;

    private TrackType(MotionModifier motion, Overlay overlay, String name) {
        this.motion = motion;
        this.overlay = overlay;
        this.name = name;
    }

    public static TrackType read(int type) {
        if (type < 0 || type >= TrackType.values().length) {
            return DEFAULT;
        }
        return TrackType.values()[type];
    }

    @FunctionalInterface
    public static interface MotionModifier {
        public static final MotionModifier FRICTION = (m, g, p, s, f) -> m - m * f;

        public double calculate(double var1, double var3, double var5, double var7, double var9);
    }

    @FunctionalInterface
    public static interface Overlay {
        public void calculateEffects(int var1, float var2, Vector3f var3, float[] var4);
    }
}

