/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.util;

import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public record Pose(Vector3dc translation, Matrix3dc basis) {
    public void interpolate(Pose other, double t, Vector3d translation, Matrix3d basis, Vector3d gradient) {
        double factor = this.translation().distance(other.translation());
        this.interpolate(other, t, factor, translation, basis, gradient);
    }

    public void interpolate(Pose other, double t, double factor, Vector3d translation, Matrix3d basis, Vector3d gradient) {
        Vector3d point0 = translation.set(this.translation());
        Vector3d point1 = new Vector3d(other.translation());
        Vector3d grad0 = new Vector3d(0.0, 0.0, 1.0).mul(this.basis());
        Vector3d grad1 = new Vector3d(0.0, 0.0, 1.0).mul(other.basis());
        Pose.cubicHermiteSpline(t, factor, (Vector3dc)point0, (Vector3dc)grad0, (Vector3dc)point1, (Vector3dc)grad1, translation, gradient);
        Vector3d ngrad = gradient.normalize(new Vector3d());
        Quaterniond rot0 = this.basis().getNormalizedRotation(new Quaterniond());
        Quaterniond rot1 = other.basis().getNormalizedRotation(new Quaterniond());
        Quaterniond rotT = rot0.nlerp((Quaterniondc)rot1, t, new Quaterniond());
        basis.set((Quaterniondc)rotT);
        Vector3d basisGrad = new Vector3d(0.0, 0.0, 1.0).mul((Matrix3dc)basis);
        Vector3d axis = ngrad.cross((Vector3dc)basisGrad, new Vector3d());
        if (axis.length() > 0.0) {
            axis.normalize();
            double angleToNewBasis = basisGrad.angleSigned((Vector3dc)ngrad, (Vector3dc)axis);
            if (angleToNewBasis != 0.0) {
                new Matrix3d().identity().rotate(angleToNewBasis, (Vector3dc)axis).mul((Matrix3dc)basis, basis).normal();
            }
        }
    }

    public static void cubicHermiteSpline(double t, double factor, Vector3dc clientPos, Vector3dc clientVelocity, Vector3dc serverPos, Vector3dc serverVelocity, Vector3d newClientPos, Vector3d newClientVelocity) {
        Vector3d temp = new Vector3d();
        Vector3d diff = new Vector3d(serverPos).sub(clientPos);
        newClientVelocity.set((Vector3dc)temp.set((Vector3dc)diff).mul(6.0 * t - 6.0 * t * t)).add((Vector3dc)temp.set(clientVelocity).mul(3.0 * t * t - 4.0 * t + 1.0).mul(factor)).add((Vector3dc)temp.set(serverVelocity).mul(3.0 * t * t - 2.0 * t).mul(factor));
        newClientPos.set(clientPos).add((Vector3dc)temp.set(clientVelocity).mul(t * t * t - 2.0 * t * t + t).mul(factor)).add((Vector3dc)temp.set((Vector3dc)diff).mul(-2.0 * t * t * t + 3.0 * t * t)).add((Vector3dc)temp.set(serverVelocity).mul(t * t * t - t * t).mul(factor));
    }
}

