/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter;

import com.etema.dpsmeter.client.DPSOverlay;
import com.etema.dpsmeter.client.KeyBindings;
import com.etema.dpsmeter.client.gui.DPSConfigScreen;
import com.etema.dpsmeter.config.DPSConfig;
import com.etema.dpsmeter.data.CombatSession;
import com.etema.dpsmeter.data.DPSTracker;
import com.etema.dpsmeter.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="dpsmeter")
public class DPSMeterMod {
    public static final String MODID = "dpsmeter";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"DPSMeter");

    public DPSMeterMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DPSConfig.register();
        NetworkHandler.register();
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        LOGGER.info("DPS Meter initialized successfully");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DPSTracker.initialize();
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, parent) -> new DPSConfigScreen((Screen)parent)));
        LOGGER.info("DPS Meter client setup completed");
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.handleKeyBindings();
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && mc.f_91073_.m_46467_() % 100L == 0L && mc.f_91074_ != null) {
                String playerName = mc.f_91074_.m_7755_().getString();
                System.out.println("=== DPS METER TICK TEST [" + playerName + "] ===");
                System.out.println("Mod active for: " + playerName);
                System.out.println("Is multiplayer: " + !mc.f_91073_.f_46443_);
                System.out.println("Network connected: " + (mc.m_91403_() != null));
            }
        }
    }

    private void handleKeyBindings() {
        Minecraft mc = Minecraft.m_91087_();
        while (KeyBindings.TOGGLE_DPS_OVERLAY.m_90859_()) {
            boolean currentState = (Boolean)DPSConfig.SHOW_OVERLAY.get();
            DPSConfig.SHOW_OVERLAY.set((Object)(!currentState ? 1 : 0));
            DPSConfig.SPEC.save();
            if (mc.f_91074_ == null) continue;
            String message = currentState ? "\u00a7cDPS Overlay disabled" : "\u00a7aDPS Overlay enabled";
            String debugMessage = message + " \u00a77[" + mc.f_91074_.m_7755_().getString() + "]";
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)debugMessage));
            System.out.println("=== OVERLAY TOGGLE [" + mc.f_91074_.m_7755_().getString() + "] ===");
            System.out.println("Overlay enabled: " + !currentState);
        }
        while (KeyBindings.RESET_DPS_STATS.m_90859_()) {
            DPSTracker.resetSession();
            if (mc.f_91074_ == null) continue;
            String playerName = mc.f_91074_.m_7755_().getString();
            String resetMessage = "\u00a7eDPS Stats reset \u00a77[" + playerName + "]";
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)resetMessage));
            System.out.println("=== DPS RESET [" + playerName + "] ===");
            System.out.println("Session reset for: " + playerName);
            CombatSession combatSession = DPSTracker.getSession();
        }
        while (KeyBindings.OPEN_CONFIG.m_90859_()) {
            if (mc.f_91080_ != null) continue;
            mc.m_91152_((Screen)new DPSConfigScreen(null));
            if (mc.f_91074_ == null) continue;
            System.out.println("=== CONFIG OPENED [" + mc.f_91074_.m_7755_().getString() + "] ===");
        }
    }

    @Mod.EventBusSubscriber(modid="dpsmeter", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            System.out.println("=== REGISTERING DPS OVERLAY ===");
            event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "dps_overlay", (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ != null && mc.f_91073_.m_46467_() % 60L == 0L && mc.f_91074_ != null) {
                    System.out.println("=== OVERLAY RENDER CALL [" + mc.f_91074_.m_7755_().getString() + "] ===");
                }
                DPSOverlay.renderOverlay(gui, guiGraphics, screenWidth, screenHeight);
            });
            LOGGER.info("DPS Overlay registered successfully");
        }

        @SubscribeEvent
        public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
            event.register(KeyBindings.TOGGLE_DPS_OVERLAY);
            event.register(KeyBindings.RESET_DPS_STATS);
            event.register(KeyBindings.OPEN_CONFIG);
            LOGGER.info("DPS Meter keybindings registered");
        }
    }
}

