/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.client;

import com.etema.dpsmeter.config.DPSConfig;
import com.etema.dpsmeter.data.CombatSession;
import com.etema.dpsmeter.data.DPSTracker;
import com.etema.dpsmeter.data.MetricType;
import com.etema.dpsmeter.data.OverlayConfig;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DPSOverlay {
    private static boolean isDragging = false;
    private static double dragStartX = 0.0;
    private static double dragStartY = 0.0;
    private static double initialOverlayX = 0.0;
    private static double initialOverlayY = 0.0;
    private static int currentOverlayWidth = 200;
    private static int currentOverlayHeight = 140;
    private static long lastPlayerActivity = System.currentTimeMillis();
    private static String lastDimension = "";

    public static void renderOverlay(ForgeGui gui, GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91066_.f_92062_) {
            return;
        }
        String playerName = mc.f_91074_.m_7755_().getString();
        System.out.println("=== OVERLAY DEBUG [" + playerName + "] ===");
        System.out.println("Show overlay config: " + String.valueOf(DPSConfig.SHOW_OVERLAY.get()));
        System.out.println("Is multiplayer: " + (mc.f_91073_ != null ? !mc.f_91073_.f_46443_ : false));
        System.out.println("Has session data: " + (DPSTracker.getSession().getTotalDamageDealt() > 0.0f));
        if (!((Boolean)DPSConfig.SHOW_OVERLAY.get()).booleanValue()) {
            System.out.println("Overlay blocked - config disabled");
            return;
        }
        DPSOverlay.checkAutoReset(mc);
        CombatSession session = DPSTracker.getSession();
        boolean hasData = session.isActive() || session.getTotalDamageDealt() > 0.0f || session.getTotalDamageReceived() > 0.0f;
        System.out.println("Has data to display: " + hasData);
        if (hasData) {
            DPSOverlay.renderMainOverlay(guiGraphics, screenWidth, screenHeight, session);
        }
    }

    private static void renderMainOverlay(GuiGraphics guiGraphics, int screenWidth, int screenHeight, CombatSession session) {
        Minecraft mc = Minecraft.m_91087_();
        float scale = OverlayConfig.getOverlayScale();
        if (mc.m_91403_() == null) {
            return;
        }
        if (mc.f_91073_ == null) {
            return;
        }
        boolean isConnected = mc.m_91403_() != null && mc.m_91403_().m_104910_().m_129536_();
        System.out.println("DPS Overlay - Connected: " + isConnected + ", Has data: " + session.isActive());
        int x = OverlayConfig.getCalculatedX(screenWidth);
        int y = OverlayConfig.getCalculatedY(screenHeight);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        int scaledX = (int)((float)x / scale);
        int scaledY = (int)((float)y / scale);
        DPSOverlay.calculateOverlaySize(mc, session);
        if (isDragging) {
            int dragBgColor = -2130706688;
            guiGraphics.m_280509_(scaledX - 5, scaledY - 5, scaledX + currentOverlayWidth + 5, scaledY + currentOverlayHeight + 5, dragBgColor);
        }
        DPSOverlay.renderBackground(guiGraphics, scaledX, scaledY, currentOverlayWidth, currentOverlayHeight);
        DPSOverlay.renderContent(guiGraphics, mc, session, scaledX, scaledY);
        guiGraphics.m_280168_().m_85849_();
    }

    private static void calculateOverlaySize(Minecraft mc, CombatSession session) {
        long warningAdvance;
        long resetTimeout;
        long warningThreshold;
        long timeSinceActivity;
        int lineHeight = 11;
        int padding = 10;
        int minWidth = 180;
        EnumSet<MetricType> visibleMetrics = OverlayConfig.getVisibleMetrics();
        int maxTextWidth = 0;
        int lines = 1;
        Object title = "DPS Meter";
        if (isDragging) {
            title = (String)title + " [DRAGGING]";
        }
        maxTextWidth = Math.max(maxTextWidth, mc.f_91062_.m_92895_((String)title));
        if (visibleMetrics.contains((Object)MetricType.TARGET_INFO) && session.getCurrentTarget() != null) {
            LivingEntity target = session.getCurrentTarget();
            String targetText = String.format("Target: %s", target.m_7755_().getString());
            maxTextWidth = Math.max(maxTextWidth, mc.f_91062_.m_92895_(targetText));
            ++lines;
            String healthText = String.format("Health: %.0f/%.0f", Float.valueOf(target.m_21223_()), Float.valueOf(target.m_21233_()));
            maxTextWidth = Math.max(maxTextWidth, mc.f_91062_.m_92895_(healthText));
            ++lines;
        }
        if (visibleMetrics.contains((Object)MetricType.CURRENT_DPS)) {
            String dpsText = String.format("Current DPS: %.1f", Float.valueOf(session.getCurrentDps()));
            maxTextWidth = Math.max(maxTextWidth, mc.f_91062_.m_92895_(dpsText));
            ++lines;
        }
        if (visibleMetrics.contains((Object)MetricType.AVERAGE_DPS)) {
            String avgDpsText = String.format("Average DPS: %.1f", Float.valueOf(session.getAverageDps()));
            maxTextWidth = Math.max(maxTextWidth, mc.f_91062_.m_92895_(avgDpsText));
            ++lines;
        }
        if (visibleMetrics.contains((Object)MetricType.TOTAL_DAMAGE)) {
            String totalText = String.format("Total Damage: %.0f", Float.valueOf(session.getTotalDamageDealt()));
            maxTextWidth = Math.max(maxTextWidth, mc.f_91062_.m_92895_(totalText));
            ++lines;
        }
        if (visibleMetrics.contains((Object)MetricType.DAMAGE_TAKEN)) {
            String takenText = String.format("Damage Taken: %.0f", Float.valueOf(session.getTotalDamageReceived()));
            maxTextWidth = Math.max(maxTextWidth, mc.f_91062_.m_92895_(takenText));
            ++lines;
        }
        if (visibleMetrics.contains((Object)MetricType.COMBAT_TIME)) {
            String timeText = String.format("Combat Time: %.1fs", Float.valueOf((float)session.getCombatDuration() / 20.0f));
            maxTextWidth = Math.max(maxTextWidth, mc.f_91062_.m_92895_(timeText));
            ++lines;
        }
        if (((Boolean)DPSConfig.ENABLE_AUTO_RESET.get()).booleanValue() && (Integer)DPSConfig.AUTO_RESET_TIMEOUT.get() > 0 && (timeSinceActivity = (System.currentTimeMillis() - lastPlayerActivity) / 1000L) >= (warningThreshold = (resetTimeout = (long)((Integer)DPSConfig.AUTO_RESET_TIMEOUT.get()).intValue()) - (warningAdvance = Math.min(10L, Math.max(1L, (long)((double)resetTimeout * 0.25)))))) {
            long timeRemaining = Math.max(0L, resetTimeout - timeSinceActivity);
            String resetWarning = String.format("Auto-reset in: %ds", timeRemaining);
            maxTextWidth = Math.max(maxTextWidth, mc.f_91062_.m_92895_(resetWarning));
            ++lines;
        }
        currentOverlayWidth = Math.max(minWidth, maxTextWidth + padding * 2);
        currentOverlayHeight = lines * lineHeight + padding * 2 + 8;
    }

    private static void renderBackground(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int bgAlpha = (Integer)DPSConfig.OVERLAY_BACKGROUND_ALPHA.get();
        int backgroundColor = bgAlpha << 24;
        guiGraphics.m_280509_(x - 5, y - 5, x + width + 5, y + height + 5, backgroundColor);
        int borderColor = -16711936;
        guiGraphics.m_280509_(x - 6, y - 6, x + width + 6, y - 5, borderColor);
        guiGraphics.m_280509_(x - 6, y + height + 5, x + width + 6, y + height + 6, borderColor);
        guiGraphics.m_280509_(x - 6, y - 6, x - 5, y + height + 6, borderColor);
        guiGraphics.m_280509_(x + width + 5, y - 6, x + width + 6, y + height + 6, borderColor);
    }

    private static void renderContent(GuiGraphics guiGraphics, Minecraft mc, CombatSession session, int x, int y) {
        long resetTimeout;
        long timeSinceActivity;
        EnumSet<MetricType> visibleMetrics = OverlayConfig.getVisibleMetrics();
        int lineHeight = 11;
        int currentY = y;
        Object title = "\u00a76\u00a7lDPS Meter";
        if (isDragging) {
            title = (String)title + " \u00a7e[DRAGGING]";
        }
        guiGraphics.m_280488_(mc.f_91062_, (String)title, x, currentY, 0xFFFFFF);
        currentY += lineHeight + 2;
        if (visibleMetrics.contains((Object)MetricType.TARGET_INFO) && session.getCurrentTarget() != null) {
            LivingEntity target = session.getCurrentTarget();
            String targetText = String.format("\u00a79Target: \u00a7f%s", target.m_7755_().getString());
            guiGraphics.m_280488_(mc.f_91062_, targetText, x, currentY, 0xFFFFFF);
            float targetHealth = target.m_21223_();
            float targetMaxHealth = target.m_21233_();
            String healthText = String.format("\u00a7rHealth: \u00a7f%.0f/%.0f", Float.valueOf(targetHealth), Float.valueOf(targetMaxHealth));
            guiGraphics.m_280488_(mc.f_91062_, healthText, x, currentY += lineHeight, 0xFFFFFF);
            currentY += lineHeight + 2;
        }
        if (visibleMetrics.contains((Object)MetricType.CURRENT_DPS)) {
            String dpsText = String.format("\u00a7aCurrent DPS: \u00a7f%.1f", Float.valueOf(session.getCurrentDps()));
            guiGraphics.m_280488_(mc.f_91062_, dpsText, x, currentY, 0xFFFFFF);
            currentY += lineHeight;
        }
        if (visibleMetrics.contains((Object)MetricType.AVERAGE_DPS)) {
            String avgDpsText = String.format("\u00a7bAverage DPS: \u00a7f%.1f", Float.valueOf(session.getAverageDps()));
            guiGraphics.m_280488_(mc.f_91062_, avgDpsText, x, currentY, 0xFFFFFF);
            currentY += lineHeight;
        }
        if (visibleMetrics.contains((Object)MetricType.TOTAL_DAMAGE)) {
            String totalText = String.format("\u00a7cTotal Damage: \u00a7f%.0f", Float.valueOf(session.getTotalDamageDealt()));
            guiGraphics.m_280488_(mc.f_91062_, totalText, x, currentY, 0xFFFFFF);
            currentY += lineHeight;
        }
        if (visibleMetrics.contains((Object)MetricType.DAMAGE_TAKEN)) {
            String takenText = String.format("\u00a7eDamage Taken: \u00a7f%.0f", Float.valueOf(session.getTotalDamageReceived()));
            guiGraphics.m_280488_(mc.f_91062_, takenText, x, currentY, 0xFFFFFF);
            currentY += lineHeight;
        }
        if (visibleMetrics.contains((Object)MetricType.COMBAT_TIME)) {
            String timeText = String.format("\u00a7dCombat Time: \u00a7f%.1fs", Float.valueOf((float)session.getCombatDuration() / 20.0f));
            guiGraphics.m_280488_(mc.f_91062_, timeText, x, currentY, 0xFFFFFF);
            currentY += lineHeight;
        }
        if (((Boolean)DPSConfig.ENABLE_AUTO_RESET.get()).booleanValue() && (Integer)DPSConfig.AUTO_RESET_TIMEOUT.get() > 0 && (double)(timeSinceActivity = (System.currentTimeMillis() - lastPlayerActivity) / 1000L) > (double)(resetTimeout = (long)((Integer)DPSConfig.AUTO_RESET_TIMEOUT.get()).intValue()) * 0.8) {
            long timeRemaining = resetTimeout - timeSinceActivity;
            String resetWarning = String.format("\u00a7cAuto-reset in: \u00a7f%ds", Math.max(0L, timeRemaining));
            guiGraphics.m_280488_(mc.f_91062_, resetWarning, x, currentY, 0xFFFFFF);
        }
    }

    private static void checkAutoReset(Minecraft mc) {
        CombatSession session;
        long timeSinceActivity;
        int timeout;
        if (!((Boolean)DPSConfig.ENABLE_AUTO_RESET.get()).booleanValue()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (((Boolean)DPSConfig.AUTO_RESET_ON_DIMENSION_CHANGE.get()).booleanValue() && mc.f_91073_ != null) {
            String currentDimension = mc.f_91073_.m_46472_().m_135782_().toString();
            if (!currentDimension.equals(lastDimension) && !lastDimension.isEmpty()) {
                DPSOverlay.resetDPSMeter(mc, "Dimension change");
            }
            lastDimension = currentDimension;
        }
        if ((timeout = ((Integer)DPSConfig.AUTO_RESET_TIMEOUT.get()).intValue()) > 0 && (timeSinceActivity = (currentTime - lastPlayerActivity) / 1000L) >= (long)timeout && ((session = DPSTracker.getSession()).getTotalDamageDealt() > 0.0f || session.getTotalDamageReceived() > 0.0f || session.isActive())) {
            DPSOverlay.resetDPSMeter(mc, "Inactivity timeout");
        }
    }

    public static void updatePlayerActivity() {
        lastPlayerActivity = System.currentTimeMillis();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && !mc.f_91073_.f_46443_) {
            DPSTracker.updateActivity();
        }
    }

    private static void resetDPSMeter(Minecraft mc, String reason) {
        DPSTracker.resetSession();
        lastPlayerActivity = System.currentTimeMillis();
        if (mc.f_91074_ != null) {
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7eDPS Meter reset: \u00a7f" + reason)));
        }
    }

    public static void onPlayerDeath() {
        if (((Boolean)DPSConfig.AUTO_RESET_ON_DEATH.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            DPSOverlay.resetDPSMeter(mc, "Player death");
        }
    }
}

