/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.client;

import com.etema.dpsmeter.config.DPSConfig;
import com.etema.dpsmeter.data.DPSTracker;
import com.etema.dpsmeter.data.FloatingNumber;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DamageNumberRenderer {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (!((Boolean)DPSConfig.SHOW_FLOATING_NUMBERS.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        List<FloatingNumber> floatingNumbers = DPSTracker.getFloatingNumbers();
        if (floatingNumbers.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        Camera camera = event.getCamera();
        poseStack.m_85836_();
        Vec3 cameraPos = camera.m_90583_();
        for (FloatingNumber number : floatingNumbers) {
            DamageNumberRenderer.renderFloatingNumber(poseStack, (MultiBufferSource)bufferSource, camera, cameraPos, number, event.getPartialTick());
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
    }

    private static void renderFloatingNumber(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, Vec3 cameraPos, FloatingNumber number, float partialTick) {
        Vec3 numberPos = number.getPosition();
        double distance = cameraPos.m_82554_(numberPos);
        if (distance > 32.0) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(numberPos.f_82479_ - cameraPos.f_82479_, numberPos.f_82480_ - cameraPos.f_82480_, numberPos.f_82481_ - cameraPos.f_82481_);
        poseStack.m_252781_(camera.m_253121_());
        float baseScale = 0.02f;
        float distanceScale = Math.max(0.5f, Math.min(2.0f, (float)(distance / 8.0)));
        float numberScale = number.getScale();
        float finalScale = baseScale * distanceScale * numberScale;
        poseStack.m_85841_(-finalScale, -finalScale, finalScale);
        String text = number.getText();
        int baseColor = number.getColor();
        float alpha = number.getAlpha();
        int alphaValue = (int)(alpha * 255.0f) << 24;
        int color = baseColor & 0xFFFFFF | alphaValue;
        if (number.isCritical()) {
            float bobOffset = Mth.m_14031_((float)(((float)number.getLifetime() + partialTick) * 0.3f)) * 0.1f;
            poseStack.m_252880_(0.0f, bobOffset, 0.0f);
            poseStack.m_85841_(1.2f, 1.2f, 1.2f);
        }
        Minecraft mc = Minecraft.m_91087_();
        int textWidth = mc.f_91062_.m_92895_(text);
        mc.f_91062_.m_271703_(text, (float)(-textWidth) / 2.0f, 0.0f, color, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0x40000000, 0xF000F0);
        poseStack.m_85849_();
    }

    public static void renderFloatingNumbersOverlay(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        if (!((Boolean)DPSConfig.SHOW_FLOATING_NUMBERS.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        List<FloatingNumber> floatingNumbers = DPSTracker.getFloatingNumbers();
        if (floatingNumbers.isEmpty()) {
            return;
        }
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        for (FloatingNumber number : floatingNumbers) {
            Vec3 numberPos = number.getPosition();
            Vec3 relativePos = numberPos.m_82546_(cameraPos);
            double distance = relativePos.m_82553_();
            if (distance > 16.0) continue;
            double screenX = (double)screenWidth / 2.0 + relativePos.f_82479_ * 100.0 / Math.max(1.0, distance);
            double screenY = (double)screenHeight / 2.0 - relativePos.f_82480_ * 100.0 / Math.max(1.0, distance);
            if (screenX < -50.0 || screenX > (double)(screenWidth + 50) || screenY < -50.0 || screenY > (double)(screenHeight + 50)) continue;
            String text = number.getText();
            float alpha = number.getAlpha();
            float scale = number.getScale();
            int color = number.getColor();
            int alphaValue = (int)(alpha * 255.0f) << 24;
            int finalColor = color & 0xFFFFFF | alphaValue;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_(screenX, screenY, 0.0);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            int textWidth = mc.f_91062_.m_92895_(text);
            guiGraphics.m_280488_(mc.f_91062_, text, -textWidth / 2, 0, finalColor);
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

