/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.client.gui;

import com.etema.dpsmeter.config.DPSConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DPSConfigScreen
extends Screen {
    private final Screen parent;
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SPACING = 25;
    private static final int SCROLL_SPEED = 20;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private int contentHeight = 0;
    private int visibleHeight = 0;
    private boolean previewMode = false;
    private boolean isDraggingOverlay = false;
    private double dragStartX = 0.0;
    private double dragStartY = 0.0;
    private double overlayX;
    private double overlayY;
    private double overlayScale;
    private Checkbox showOverlay;
    private Checkbox showFloatingNumbers;
    private Checkbox enableGuiDragging;
    private Checkbox trackPetsDamage;
    private Checkbox showOverkillDamage;
    private Checkbox enableAutoReset;
    private Checkbox autoResetOnDeath;
    private Checkbox autoResetOnDimensionChange;
    private SliderWidget overlayScaleSlider;
    private SliderWidget overlayOpacitySlider;
    private SliderWidget autoResetTimeoutSlider;
    private SliderWidget combatTimeoutSlider;
    private SliderWidget dpsUpdateIntervalSlider;
    private Button resetButton;
    private Button saveButton;
    private Button cancelButton;
    private Button previewButton;

    public DPSConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"DPS Meter Configuration"));
        this.parent = parent;
        this.overlayX = (Double)DPSConfig.OVERLAY_X.get();
        this.overlayY = (Double)DPSConfig.OVERLAY_Y.get();
        this.overlayScale = (Double)DPSConfig.OVERLAY_SCALE.get();
    }

    protected void m_7856_() {
        int startY;
        super.m_7856_();
        this.visibleHeight = this.f_96544_ - 160;
        int centerX = (this.f_96543_ - 200) / 2;
        int currentY = startY = 80;
        this.showOverlay = this.addCheckbox(centerX, currentY += 20, "Show DPS Overlay", (Boolean)DPSConfig.SHOW_OVERLAY.get());
        this.showFloatingNumbers = this.addCheckbox(centerX, currentY += 25, "Show Floating Numbers", (Boolean)DPSConfig.SHOW_FLOATING_NUMBERS.get());
        this.enableGuiDragging = this.addCheckbox(centerX, currentY += 25, "Enable GUI Dragging", (Boolean)DPSConfig.ENABLE_GUI_DRAGGING.get());
        currentY += 40;
        this.overlayScaleSlider = this.addSlider(centerX, currentY += 20, "Overlay Scale", (Double)DPSConfig.OVERLAY_SCALE.get(), 0.5, 3.0, "x");
        this.overlayOpacitySlider = this.addSlider(centerX, currentY += 25, "Overlay Opacity", ((Integer)DPSConfig.OVERLAY_BACKGROUND_ALPHA.get()).intValue(), 0.0, 255.0, "");
        this.dpsUpdateIntervalSlider = this.addSlider(centerX, currentY += 25, "DPS Update Interval", ((Integer)DPSConfig.DPS_UPDATE_INTERVAL.get()).intValue(), 1.0, 100.0, " ticks");
        currentY += 40;
        this.combatTimeoutSlider = this.addSlider(centerX, currentY += 20, "Combat Timeout", (double)((Integer)DPSConfig.COMBAT_TIMEOUT.get()).intValue() / 20.0, 1.0, 60.0, "s");
        this.trackPetsDamage = this.addCheckbox(centerX, currentY += 25, "Track Pets Damage", (Boolean)DPSConfig.TRACK_PETS_DAMAGE.get());
        this.showOverkillDamage = this.addCheckbox(centerX, currentY += 25, "Show Overkill Damage", (Boolean)DPSConfig.SHOW_OVERKILL_DAMAGE.get());
        currentY += 40;
        this.enableAutoReset = this.addCheckbox(centerX, currentY += 20, "Enable Auto Reset", (Boolean)DPSConfig.ENABLE_AUTO_RESET.get());
        this.autoResetTimeoutSlider = this.addSlider(centerX, currentY += 25, "Auto Reset Timeout", ((Integer)DPSConfig.AUTO_RESET_TIMEOUT.get()).intValue(), 0.0, 300.0, "s");
        this.autoResetOnDeath = this.addCheckbox(centerX, currentY += 25, "Auto Reset on Death", (Boolean)DPSConfig.AUTO_RESET_ON_DEATH.get());
        this.autoResetOnDimensionChange = this.addCheckbox(centerX, currentY += 25, "Auto Reset on Dimension Change", (Boolean)DPSConfig.AUTO_RESET_ON_DIMENSION_CHANGE.get());
        this.contentHeight = (currentY += 55) - startY;
        this.maxScrollOffset = Math.max(0, this.contentHeight - this.visibleHeight);
        int bottomY = this.f_96544_ - 50;
        int buttonSpacing = 8;
        int smallButtonWidth = 150;
        int totalButtonWidth = smallButtonWidth * 4 + buttonSpacing * 3;
        int startX = (this.f_96543_ - totalButtonWidth) / 2;
        this.previewButton = Button.m_253074_((Component)Component.m_237113_((String)(this.previewMode ? "\u00a7cExit Preview" : "\u00a7aPreview & Position")), button -> this.togglePreviewMode()).m_252987_(startX, bottomY, smallButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.previewButton);
        this.resetButton = Button.m_253074_((Component)Component.m_237113_((String)"Reset Defaults"), button -> this.resetToDefaults()).m_252987_(startX + smallButtonWidth + buttonSpacing, bottomY, smallButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.resetButton);
        this.saveButton = Button.m_253074_((Component)Component.m_237113_((String)"Save & Close"), button -> this.saveAndClose()).m_252987_(startX + (smallButtonWidth + buttonSpacing) * 2, bottomY, smallButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.m_7379_()).m_252987_(startX + (smallButtonWidth + buttonSpacing) * 3, bottomY, smallButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
    }

    private Checkbox addCheckbox(int x, int y, String text, boolean value) {
        Checkbox checkbox = new Checkbox(x, y, 200, 20, (Component)Component.m_237113_((String)text), value);
        this.m_142416_((GuiEventListener)checkbox);
        return checkbox;
    }

    private SliderWidget addSlider(int x, int y, String prefix, double value, double min, double max, String suffix) {
        SliderWidget slider = new SliderWidget(x, y, 200, 20, prefix, value, min, max, suffix);
        this.m_142416_((GuiEventListener)slider);
        return slider;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.maxScrollOffset > 0) {
            int scrollDirection = delta > 0.0 ? -1 : 1;
            this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset + scrollDirection * 20));
            this.updateWidgetPositions();
            return true;
        }
        return false;
    }

    private void updateWidgetPositions() {
        int startY;
        int centerX = (this.f_96543_ - 200) / 2;
        int currentY = startY = 80 - this.scrollOffset;
        this.showOverlay.m_253211_(currentY += 20);
        this.showFloatingNumbers.m_253211_(currentY += 25);
        this.enableGuiDragging.m_253211_(currentY += 25);
        currentY += 40;
        this.overlayScaleSlider.m_253211_(currentY += 20);
        this.overlayOpacitySlider.m_253211_(currentY += 25);
        this.dpsUpdateIntervalSlider.m_253211_(currentY += 25);
        currentY += 40;
        this.combatTimeoutSlider.m_253211_(currentY += 20);
        this.trackPetsDamage.m_253211_(currentY += 25);
        this.showOverkillDamage.m_253211_(currentY += 25);
        currentY += 40;
        this.enableAutoReset.m_253211_(currentY += 20);
        this.autoResetTimeoutSlider.m_253211_(currentY += 25);
        this.autoResetOnDeath.m_253211_(currentY += 25);
        this.autoResetOnDimensionChange.m_253211_(currentY += 25);
        currentY += 55;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int startY;
        this.m_280273_(guiGraphics);
        guiGraphics.m_280137_(this.f_96547_, "\u00a76\u00a7lDPS Meter Configuration", this.f_96543_ / 2, 20, 0xFFFFFF);
        String subtitle = this.previewMode ? "\u00a7e\u00a7lPREVIEW MODE - Drag overlay to move \u2022 +/- keys to scale" : "\u00a77Configure your DPS meter settings";
        guiGraphics.m_280137_(this.f_96547_, subtitle, this.f_96543_ / 2, 35, 0xAAAAAA);
        if (this.maxScrollOffset > 0) {
            String scrollInfo = String.format("\u00a77Scroll: %d/%d", this.scrollOffset, this.maxScrollOffset);
            guiGraphics.m_280488_(this.f_96547_, scrollInfo, 10, this.f_96544_ - 30, 0x888888);
            guiGraphics.m_280137_(this.f_96547_, "\u00a77Use mouse wheel to scroll", this.f_96543_ / 2, this.f_96544_ - 15, 0x666666);
        }
        int centerX = (this.f_96543_ - 200) / 2;
        int currentY = startY = 80 - this.scrollOffset;
        this.renderSectionHeader(guiGraphics, centerX, currentY, "\u00a76\u00a7lDisplay Settings");
        this.renderSectionHeader(guiGraphics, centerX, currentY += 110, "\u00a7b\u00a7lVisual Settings");
        this.renderSectionHeader(guiGraphics, centerX, currentY += 110, "\u00a7c\u00a7lCombat Settings");
        this.renderSectionHeader(guiGraphics, centerX, currentY += 110, "\u00a7e\u00a7lAuto Reset Settings");
        guiGraphics.m_280588_(0, 80, this.f_96543_, 80 + this.visibleHeight);
        this.f_169369_.forEach(widget -> {
            if (widget != this.resetButton && widget != this.saveButton && widget != this.cancelButton && widget != this.previewButton) {
                widget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
        });
        guiGraphics.m_280618_();
        this.renderBottomButtons(guiGraphics, mouseX, mouseY, partialTick);
        if (this.previewMode) {
            this.renderPreviewOverlays(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderSectionHeader(GuiGraphics guiGraphics, int x, int y, String text) {
        if (y >= 80 && y <= 80 + this.visibleHeight) {
            guiGraphics.m_280137_(this.f_96547_, text, this.f_96543_ / 2, y, 0xFFFFFF);
        }
    }

    private void renderBottomButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int bottomY = this.f_96544_ - 70;
        guiGraphics.m_280509_(0, bottomY, this.f_96543_, this.f_96544_, 0x40000000);
        this.previewButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.resetButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.saveButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.cancelButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void togglePreviewMode() {
        this.previewMode = !this.previewMode;
        this.isDraggingOverlay = false;
        if (this.previewMode && this.overlayScaleSlider != null) {
            this.overlayScale = this.overlayScaleSlider.getValue();
        }
        this.m_169413_();
        this.m_7856_();
    }

    private void renderPreviewOverlays(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.showOverlay.m_93840_()) {
            this.renderPreviewDPSOverlay(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderPreviewDPSOverlay(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        float scale = (float)this.overlayScale;
        int x = (int)((double)this.f_96543_ * this.overlayX);
        int y = (int)((double)this.f_96544_ * this.overlayY);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        int scaledX = (int)((float)x / scale);
        int scaledY = (int)((float)y / scale);
        int bgWidth = 200;
        int bgHeight = 120;
        int opacity = (int)this.overlayOpacitySlider.getValue();
        int bgColor = this.isDraggingOverlay ? -2130706688 : opacity << 24;
        guiGraphics.m_280509_(scaledX - 3, scaledY - 3, scaledX + bgWidth, scaledY + bgHeight, bgColor);
        int borderColor = this.isDraggingOverlay ? -256 : -16711936;
        guiGraphics.m_280509_(scaledX - 3, scaledY - 3, scaledX + bgWidth, scaledY - 1, borderColor);
        guiGraphics.m_280509_(scaledX - 3, scaledY + bgHeight, scaledX + bgWidth, scaledY + bgHeight + 2, borderColor);
        guiGraphics.m_280509_(scaledX - 3, scaledY - 3, scaledX - 1, scaledY + bgHeight + 2, borderColor);
        guiGraphics.m_280509_(scaledX + bgWidth, scaledY - 3, scaledX + bgWidth + 2, scaledY + bgHeight + 2, borderColor);
        int lineHeight = 11;
        int currentY = scaledY;
        Object title = "\u00a76\u00a7lDPS Meter";
        title = this.isDraggingOverlay ? (String)title + " \u00a7e[DRAGGING]" : (String)title + " \u00a7a[PREVIEW]";
        guiGraphics.m_280488_(this.f_96547_, (String)title, scaledX, currentY, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7aCurrent DPS: \u00a7f125.6", scaledX, currentY += lineHeight + 2, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7bAverage DPS: \u00a7f98.3", scaledX, currentY += lineHeight, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7cTotal Damage: \u00a7f15,234", scaledX, currentY += lineHeight, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7eDamage Taken: \u00a7f2,456", scaledX, currentY += lineHeight, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7dCombat Time: \u00a7f123.4s", scaledX, currentY += lineHeight, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a79Target: \u00a7fPreview Dummy", scaledX, currentY += lineHeight, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, String.format("\u00a77Scale: \u00a7f%.1fx", Float.valueOf(scale)), scaledX, scaledY + bgHeight - 12, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, String.format("\u00a77Opacity: \u00a7f%d", opacity), scaledX + bgWidth - 80, scaledY + bgHeight - 24, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, String.format("\u00a77Pos: \u00a7f%.1f, %.1f", this.overlayX, this.overlayY), scaledX + bgWidth - 80, scaledY + bgHeight - 12, 0xFFFFFF);
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.previewMode && button == 0 && this.showOverlay.m_93840_() && this.isMouseOverDPSOverlay(mouseX, mouseY)) {
            this.isDraggingOverlay = true;
            this.dragStartX = mouseX;
            this.dragStartY = mouseY;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDraggingOverlay) {
            this.isDraggingOverlay = false;
            this.overlayScaleSlider.updateFromPreview(this.overlayScale);
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.previewMode && button == 0 && this.isDraggingOverlay) {
            double deltaX = (mouseX - this.dragStartX) / (double)this.f_96543_;
            double deltaY = (mouseY - this.dragStartY) / (double)this.f_96544_;
            this.overlayX = Math.max(0.0, Math.min(0.8, this.overlayX + deltaX));
            this.overlayY = Math.max(0.0, Math.min(0.8, this.overlayY + deltaY));
            this.dragStartX = mouseX;
            this.dragStartY = mouseY;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.previewMode) {
            if (keyCode == 61 || keyCode == 334) {
                this.overlayScale = Math.min(3.0, this.overlayScale + 0.1);
                this.overlayScaleSlider.updateFromPreview(this.overlayScale);
                return true;
            }
            if (keyCode == 45 || keyCode == 333) {
                this.overlayScale = Math.max(0.5, this.overlayScale - 0.1);
                this.overlayScaleSlider.updateFromPreview(this.overlayScale);
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private boolean isMouseOverDPSOverlay(double mouseX, double mouseY) {
        if (!this.showOverlay.m_93840_()) {
            return false;
        }
        float scale = (float)this.overlayScale;
        int x = (int)((double)this.f_96543_ * this.overlayX);
        int y = (int)((double)this.f_96544_ * this.overlayY);
        int width = (int)(200.0f * scale);
        int height = (int)(120.0f * scale);
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    private void resetToDefaults() {
        DPSConfig.SHOW_OVERLAY.set((Object)true);
        DPSConfig.SHOW_FLOATING_NUMBERS.set((Object)false);
        DPSConfig.ENABLE_GUI_DRAGGING.set((Object)true);
        DPSConfig.TRACK_PETS_DAMAGE.set((Object)true);
        DPSConfig.SHOW_OVERKILL_DAMAGE.set((Object)false);
        DPSConfig.ENABLE_AUTO_RESET.set((Object)false);
        DPSConfig.AUTO_RESET_ON_DEATH.set((Object)true);
        DPSConfig.AUTO_RESET_ON_DIMENSION_CHANGE.set((Object)true);
        DPSConfig.OVERLAY_SCALE.set((Object)1.0);
        DPSConfig.OVERLAY_BACKGROUND_ALPHA.set((Object)180);
        DPSConfig.AUTO_RESET_TIMEOUT.set((Object)60);
        DPSConfig.COMBAT_TIMEOUT.set((Object)200);
        DPSConfig.DPS_UPDATE_INTERVAL.set((Object)10);
        this.overlayX = 0.01;
        this.overlayY = 0.01;
        this.overlayScale = 1.0;
        this.previewMode = false;
        this.isDraggingOverlay = false;
        DPSConfig.SPEC.save();
        this.m_169413_();
        this.m_7856_();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7eSettings reset to defaults!"));
        }
    }

    private void saveAndClose() {
        DPSConfig.SHOW_OVERLAY.set((Object)this.showOverlay.m_93840_());
        DPSConfig.SHOW_FLOATING_NUMBERS.set((Object)this.showFloatingNumbers.m_93840_());
        DPSConfig.ENABLE_GUI_DRAGGING.set((Object)this.enableGuiDragging.m_93840_());
        DPSConfig.TRACK_PETS_DAMAGE.set((Object)this.trackPetsDamage.m_93840_());
        DPSConfig.SHOW_OVERKILL_DAMAGE.set((Object)this.showOverkillDamage.m_93840_());
        DPSConfig.ENABLE_AUTO_RESET.set((Object)this.enableAutoReset.m_93840_());
        DPSConfig.AUTO_RESET_ON_DEATH.set((Object)this.autoResetOnDeath.m_93840_());
        DPSConfig.AUTO_RESET_ON_DIMENSION_CHANGE.set((Object)this.autoResetOnDimensionChange.m_93840_());
        DPSConfig.OVERLAY_SCALE.set((Object)this.overlayScaleSlider.getValue());
        DPSConfig.OVERLAY_BACKGROUND_ALPHA.set((Object)((int)this.overlayOpacitySlider.getValue()));
        DPSConfig.AUTO_RESET_TIMEOUT.set((Object)((int)this.autoResetTimeoutSlider.getValue()));
        DPSConfig.COMBAT_TIMEOUT.set((Object)((int)(this.combatTimeoutSlider.getValue() * 20.0)));
        DPSConfig.DPS_UPDATE_INTERVAL.set((Object)((int)this.dpsUpdateIntervalSlider.getValue()));
        DPSConfig.OVERLAY_X.set((Object)this.overlayX);
        DPSConfig.OVERLAY_Y.set((Object)this.overlayY);
        DPSConfig.SPEC.save();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aSettings saved successfully!"));
        }
        this.m_7379_();
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private class SliderWidget
    extends AbstractSliderButton {
        private final String prefix;
        private final double minValue;
        private final double maxValue;
        private final String suffix;
        private double currentValue;

        public SliderWidget(int x, int y, int width, int height, String prefix, double initialValue, double minValue, double maxValue, String suffix) {
            super(x, y, width, height, (Component)Component.m_237119_(), (initialValue - minValue) / (maxValue - minValue));
            this.prefix = prefix;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.suffix = suffix;
            this.currentValue = initialValue;
            this.m_5695_();
        }

        protected void m_5695_() {
            if (this.suffix.equals("s") || this.suffix.equals(" ticks")) {
                this.m_93666_((Component)Component.m_237113_((String)String.format("%s: %.0f%s", this.prefix, this.currentValue, this.suffix)));
            } else if (this.suffix.isEmpty()) {
                this.m_93666_((Component)Component.m_237113_((String)String.format("%s: %.0f", this.prefix, this.currentValue)));
            } else {
                this.m_93666_((Component)Component.m_237113_((String)String.format("%s: %.1f%s", this.prefix, this.currentValue, this.suffix)));
            }
        }

        protected void m_5697_() {
            this.currentValue = this.minValue + this.f_93577_ * (this.maxValue - this.minValue);
            this.m_5695_();
            if (this.prefix.equals("Overlay Scale")) {
                DPSConfigScreen.this.overlayScale = this.currentValue;
            } else if (this.prefix.equals("Overlay Opacity")) {
                // empty if block
            }
        }

        public double getValue() {
            return this.currentValue;
        }

        public void updateFromPreview(double newValue) {
            this.currentValue = newValue;
            this.f_93577_ = (newValue - this.minValue) / (this.maxValue - this.minValue);
            this.m_5695_();
        }
    }
}

