/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class DPSConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.BooleanValue SHOW_OVERLAY;
    public static final ForgeConfigSpec.BooleanValue SHOW_FLOATING_NUMBERS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_GUI_DRAGGING;
    public static final ForgeConfigSpec.DoubleValue OVERLAY_X;
    public static final ForgeConfigSpec.DoubleValue OVERLAY_Y;
    public static final ForgeConfigSpec.DoubleValue OVERLAY_SCALE;
    public static final ForgeConfigSpec.IntValue OVERLAY_BACKGROUND_ALPHA;
    public static final ForgeConfigSpec.IntValue DPS_UPDATE_INTERVAL;
    public static final ForgeConfigSpec.IntValue COMBAT_TIMEOUT;
    public static final ForgeConfigSpec.BooleanValue TRACK_PETS_DAMAGE;
    public static final ForgeConfigSpec.BooleanValue SHOW_OVERKILL_DAMAGE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_AUTO_RESET;
    public static final ForgeConfigSpec.IntValue AUTO_RESET_TIMEOUT;
    public static final ForgeConfigSpec.BooleanValue AUTO_RESET_ON_DEATH;
    public static final ForgeConfigSpec.BooleanValue AUTO_RESET_ON_DIMENSION_CHANGE;
    public static final ForgeConfigSpec SPEC;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC);
    }

    static {
        BUILDER.comment("DPS Meter Configuration").push("display");
        SHOW_OVERLAY = BUILDER.comment("Show the main DPS overlay").define("show_overlay", true);
        SHOW_FLOATING_NUMBERS = BUILDER.comment("Show floating damage numbers").define("show_floating_numbers", false);
        ENABLE_GUI_DRAGGING = BUILDER.comment("Enable dragging the GUI overlay with mouse").define("enable_gui_dragging", true);
        BUILDER.pop().push("positioning");
        OVERLAY_X = BUILDER.comment("X position of overlay (0.0 to 1.0)").defineInRange("overlay_x", 0.01, 0.0, 1.0);
        OVERLAY_Y = BUILDER.comment("Y position of overlay (0.0 to 1.0)").defineInRange("overlay_y", 0.01, 0.0, 1.0);
        OVERLAY_SCALE = BUILDER.comment("Scale of overlay").defineInRange("overlay_scale", 1.0, 0.5, 3.0);
        BUILDER.pop().push("visual");
        OVERLAY_BACKGROUND_ALPHA = BUILDER.comment("Background transparency (0-255)").defineInRange("overlay_background_alpha", 180, 0, 255);
        DPS_UPDATE_INTERVAL = BUILDER.comment("DPS calculation update interval in ticks").defineInRange("dps_update_interval", 10, 1, 100);
        BUILDER.pop().push("combat");
        COMBAT_TIMEOUT = BUILDER.comment("Combat timeout in ticks (20 = 1 second)").defineInRange("combat_timeout", 200, 20, 1200);
        TRACK_PETS_DAMAGE = BUILDER.comment("Include pet/summon damage in calculations").define("track_pets_damage", true);
        SHOW_OVERKILL_DAMAGE = BUILDER.comment("Show overkill damage in calculations").define("show_overkill_damage", false);
        BUILDER.pop().push("auto_reset");
        ENABLE_AUTO_RESET = BUILDER.comment("Enable automatic DPS meter reset after inactivity").define("enable_auto_reset", false);
        AUTO_RESET_TIMEOUT = BUILDER.comment("Auto reset timeout in seconds (0 = disabled)").defineInRange("auto_reset_timeout", 60, 0, 3600);
        AUTO_RESET_ON_DEATH = BUILDER.comment("Auto reset DPS meter when player dies").define("auto_reset_on_death", true);
        AUTO_RESET_ON_DIMENSION_CHANGE = BUILDER.comment("Auto reset DPS meter when changing dimensions").define("auto_reset_on_dimension_change", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

