/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.core;

import com.etema.dpsmeter.config.DPSConfig;
import com.etema.dpsmeter.data.DPSTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DPSManager {
    private static long lastUpdateTick = 0L;
    private static final int UPDATE_INTERVAL = 10;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        long currentTick = mc.f_91073_.m_46467_();
        if (currentTick - lastUpdateTick >= 10L) {
            DPSTracker.tick();
            lastUpdateTick = currentTick;
        }
        DPSTracker.updateFloatingNumbers();
    }

    public static void recordDamage(LivingEntity attacker, LivingEntity target, float damage) {
        if (attacker == null || target == null || damage <= 0.0f) {
            return;
        }
        DPSTracker.recordDamage(attacker, target, damage);
        if (((Boolean)DPSConfig.SHOW_FLOATING_NUMBERS.get()).booleanValue()) {
            DPSTracker.addFloatingNumber(target, damage);
        }
    }

    public static void recordPlayerDamage(float damage, LivingEntity target) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || target == null || damage <= 0.0f) {
            return;
        }
        DPSManager.recordDamage((LivingEntity)mc.f_91074_, target, damage);
    }

    public static void recordDamageReceived(float damage, LivingEntity attacker) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || attacker == null || damage <= 0.0f) {
            return;
        }
        DPSTracker.recordDamageReceived((LivingEntity)mc.f_91074_, attacker, damage);
    }
}

