/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.data;

import com.etema.dpsmeter.config.DPSConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;

public class CombatSession {
    private long startTick;
    private long lastDamageTick;
    private long endTick;
    private long startTime;
    private long lastDamageTime;
    private long endTime;
    private float totalDamageDealt;
    private float totalDamageReceived;
    private int totalHits;
    private int totalHitsReceived;
    private final Map<String, Float> damageByTarget = new HashMap<String, Float>();
    private final List<Float> recentDamage = new ArrayList<Float>();
    private final List<Long> damageTicks = new ArrayList<Long>();
    private LivingEntity currentTarget;
    private final List<LivingEntity> availableTargets = new ArrayList<LivingEntity>();
    private boolean isActive = false;
    private float currentDps = 0.0f;
    private float averageDps = 0.0f;

    public CombatSession() {
        this.reset();
    }

    public void recordDamage(LivingEntity target, float damage) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        long currentTick = mc.f_91073_.m_46467_();
        long currentTime = System.currentTimeMillis();
        if (!this.isActive) {
            this.startCombat(currentTick, currentTime);
        }
        this.lastDamageTick = currentTick;
        this.lastDamageTime = currentTime;
        this.totalDamageDealt += damage;
        ++this.totalHits;
        String targetName = target.m_5446_().getString();
        this.damageByTarget.put(targetName, Float.valueOf(this.damageByTarget.getOrDefault(targetName, Float.valueOf(0.0f)).floatValue() + damage));
        this.recentDamage.add(Float.valueOf(damage));
        this.damageTicks.add(currentTick);
        if (this.currentTarget == null) {
            this.setCurrentTarget(target);
        }
        if (!this.availableTargets.contains(target)) {
            this.availableTargets.add(target);
        }
        this.updateDPS();
    }

    public void recordDamageReceived(LivingEntity attacker, float damage) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        long currentTick = mc.f_91073_.m_46467_();
        long currentTime = System.currentTimeMillis();
        if (!this.isActive) {
            this.startCombat(currentTick, currentTime);
        }
        this.lastDamageTick = currentTick;
        this.lastDamageTime = currentTime;
        this.totalDamageReceived += damage;
        ++this.totalHitsReceived;
        this.updateDPS();
    }

    private void startCombat(long tick, long time) {
        this.isActive = true;
        this.startTick = tick;
        this.startTime = time;
        this.lastDamageTick = tick;
        this.lastDamageTime = time;
    }

    public void endCombat() {
        if (this.isActive) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null) {
                this.endTick = mc.f_91073_.m_46467_();
                this.endTime = System.currentTimeMillis();
            }
            this.isActive = false;
        }
    }

    public void tick() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        long currentTick = mc.f_91073_.m_46467_();
        this.cleanupOldDamage(currentTick);
        if (this.isActive) {
            this.updateDPS();
        }
        this.availableTargets.removeIf(entity -> !entity.m_6084_() || entity.m_213877_());
        if (this.currentTarget != null && (!this.currentTarget.m_6084_() || this.currentTarget.m_213877_())) {
            this.currentTarget = null;
        }
    }

    private void cleanupOldDamage(long currentTick) {
        int dpsInterval = (Integer)DPSConfig.DPS_UPDATE_INTERVAL.get();
        while (!this.damageTicks.isEmpty() && currentTick - this.damageTicks.get(0) > (long)dpsInterval * 3L) {
            this.damageTicks.remove(0);
            this.recentDamage.remove(0);
        }
    }

    private void updateDPS() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        long currentTick = mc.f_91073_.m_46467_();
        int dpsInterval = (Integer)DPSConfig.DPS_UPDATE_INTERVAL.get();
        float recentDamageSum = 0.0f;
        for (int i = this.damageTicks.size() - 1; i >= 0 && currentTick - this.damageTicks.get(i) <= (long)dpsInterval; --i) {
            recentDamageSum += this.recentDamage.get(i).floatValue();
        }
        this.currentDps = recentDamageSum / (float)dpsInterval * 20.0f;
        long combatDuration = this.getCombatDuration();
        if (combatDuration > 0L) {
            this.averageDps = this.totalDamageDealt / (float)combatDuration * 20.0f;
        }
    }

    public void setCurrentTarget(LivingEntity target) {
        this.currentTarget = target;
        if (target != null && !this.availableTargets.contains(target)) {
            this.availableTargets.add(target);
        }
    }

    public void switchToNextTarget() {
        if (this.availableTargets.isEmpty()) {
            this.currentTarget = null;
            return;
        }
        int currentIndex = this.availableTargets.indexOf(this.currentTarget);
        int nextIndex = (currentIndex + 1) % this.availableTargets.size();
        this.currentTarget = this.availableTargets.get(nextIndex);
    }

    public void reset() {
        this.startTick = 0L;
        this.lastDamageTick = 0L;
        this.endTick = 0L;
        this.startTime = 0L;
        this.lastDamageTime = 0L;
        this.endTime = 0L;
        this.totalDamageDealt = 0.0f;
        this.totalDamageReceived = 0.0f;
        this.totalHits = 0;
        this.totalHitsReceived = 0;
        this.currentDps = 0.0f;
        this.averageDps = 0.0f;
        this.isActive = false;
        this.damageByTarget.clear();
        this.recentDamage.clear();
        this.damageTicks.clear();
        this.availableTargets.clear();
        this.currentTarget = null;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public float getTotalDamageDealt() {
        return this.totalDamageDealt;
    }

    public float getTotalDamageReceived() {
        return this.totalDamageReceived;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public float getCurrentDps() {
        return this.currentDps;
    }

    public float getAverageDps() {
        return this.averageDps;
    }

    public LivingEntity getCurrentTarget() {
        return this.currentTarget;
    }

    public Map<String, Float> getDamageByTarget() {
        return new HashMap<String, Float>(this.damageByTarget);
    }

    public long getCombatDuration() {
        if (this.startTick == 0L) {
            return 0L;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return 0L;
        }
        long currentTick = this.isActive ? mc.f_91073_.m_46467_() : this.endTick;
        return currentTick - this.startTick;
    }

    public long getTimeSinceLastDamage() {
        if (this.lastDamageTime == 0L) {
            return Long.MAX_VALUE;
        }
        return System.currentTimeMillis() - this.lastDamageTime;
    }

    public float getHitRate() {
        long duration = this.getCombatDuration();
        if (duration <= 0L) {
            return 0.0f;
        }
        return (float)this.totalHits / ((float)duration / 20.0f);
    }

    public float getAverageDamagePerHit() {
        if (this.totalHits <= 0) {
            return 0.0f;
        }
        return this.totalDamageDealt / (float)this.totalHits;
    }
}

