/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.data;

import com.etema.dpsmeter.config.DPSConfig;
import com.etema.dpsmeter.data.CombatSession;
import com.etema.dpsmeter.data.FloatingNumber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class DPSTracker {
    private static CombatSession currentSession;
    private static final List<FloatingNumber> floatingNumbers;
    private static long lastActivityTime;
    private static long lastCombatCheckTime;

    public static void initialize() {
        currentSession = new CombatSession();
        floatingNumbers.clear();
        lastActivityTime = System.currentTimeMillis();
    }

    public static CombatSession getSession() {
        if (currentSession == null) {
            currentSession = new CombatSession();
        }
        return currentSession;
    }

    public static void recordDamage(LivingEntity attacker, LivingEntity target, float damage) {
        if (attacker == null || target == null || damage <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        String playerName = mc.f_91074_.m_7755_().getString();
        System.out.println("=== TRACKING DAMAGE [" + playerName + "] ===");
        System.out.println("Attacker: " + attacker.m_7755_().getString());
        System.out.println("Target: " + target.m_7755_().getString());
        System.out.println("Damage: " + damage);
        System.out.println("Player UUID: " + String.valueOf(mc.f_91074_.m_20148_()));
        System.out.println("Attacker UUID: " + String.valueOf(attacker.m_20148_()));
        lastActivityTime = System.currentTimeMillis();
        if (attacker.m_20148_().equals(mc.f_91074_.m_20148_())) {
            System.out.println("Recording damage for player: " + playerName);
            DPSTracker.getSession().recordDamage(target, damage);
        } else {
            System.out.println("Damage not recorded - different attacker");
        }
    }

    public static void recordDamageReceived(LivingEntity player, LivingEntity attacker, float damage) {
        if (player == null || attacker == null || damage <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || !player.m_20148_().equals(mc.f_91074_.m_20148_())) {
            return;
        }
        String playerName = mc.f_91074_.m_7755_().getString();
        System.out.println("=== TRACKING DAMAGE RECEIVED [" + playerName + "] ===");
        System.out.println("Attacker: " + attacker.m_7755_().getString());
        System.out.println("Damage: " + damage);
        lastActivityTime = System.currentTimeMillis();
        DPSTracker.getSession().recordDamageReceived(attacker, damage);
    }

    public static void tick() {
        if (currentSession != null) {
            currentSession.tick();
            DPSTracker.checkCombatTimeout();
            DPSTracker.checkAutoReset();
        }
        DPSTracker.updateFloatingNumbers();
    }

    private static void checkCombatTimeout() {
        long combatTimeout;
        if (!currentSession.isActive()) {
            return;
        }
        long timeSinceLastDamage = currentSession.getTimeSinceLastDamage();
        if (timeSinceLastDamage > (combatTimeout = (long)((Integer)DPSConfig.COMBAT_TIMEOUT.get()).intValue() * 50L)) {
            currentSession.endCombat();
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77Combat ended - timeout reached"));
            }
        }
    }

    private static void checkAutoReset() {
        if (!((Boolean)DPSConfig.ENABLE_AUTO_RESET.get()).booleanValue()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCombatCheckTime < 5000L) {
            return;
        }
        lastCombatCheckTime = currentTime;
        long timeSinceActivity = currentTime - lastActivityTime;
        long resetTimeout = (long)((Integer)DPSConfig.AUTO_RESET_TIMEOUT.get()).intValue() * 1000L;
        if (resetTimeout > 0L && timeSinceActivity > resetTimeout) {
            boolean hasDataToReset;
            boolean bl = hasDataToReset = currentSession.getTotalDamageDealt() > 0.0f || currentSession.getTotalDamageReceived() > 0.0f || currentSession.isActive();
            if (hasDataToReset) {
                DPSTracker.resetSession();
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null) {
                    mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7eDPS Meter auto-reset: \u00a7finactivity timeout"));
                }
            }
        }
    }

    public static void addFloatingNumber(LivingEntity target, float damage) {
        if (target == null || damage <= 0.0f) {
            return;
        }
        Vec3 pos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() + 0.5, 0.0);
        double offsetX = (Math.random() - 0.5) * 2.0;
        double offsetZ = (Math.random() - 0.5) * 2.0;
        pos = pos.m_82520_(offsetX, 0.0, offsetZ);
        FloatingNumber floatingNumber = new FloatingNumber(pos, damage, 60);
        floatingNumbers.add(floatingNumber);
        if (floatingNumbers.size() > 50) {
            floatingNumbers.remove(0);
        }
    }

    public static void updateFloatingNumbers() {
        Iterator<FloatingNumber> iterator = floatingNumbers.iterator();
        while (iterator.hasNext()) {
            FloatingNumber number = iterator.next();
            number.tick();
            if (!number.isExpired()) continue;
            iterator.remove();
        }
    }

    public static List<FloatingNumber> getFloatingNumbers() {
        return new ArrayList<FloatingNumber>(floatingNumbers);
    }

    public static void resetSession() {
        if (currentSession != null) {
            currentSession.reset();
        }
        floatingNumbers.clear();
        lastActivityTime = System.currentTimeMillis();
    }

    public static void endCombat() {
        if (currentSession != null) {
            currentSession.endCombat();
        }
    }

    public static boolean isInCombat() {
        return currentSession != null && currentSession.isActive();
    }

    public static void updateActivity() {
        lastActivityTime = System.currentTimeMillis();
    }

    public static long getTimeSinceLastActivity() {
        return System.currentTimeMillis() - lastActivityTime;
    }

    static {
        floatingNumbers = new ArrayList<FloatingNumber>();
        lastActivityTime = System.currentTimeMillis();
        lastCombatCheckTime = 0L;
    }
}

