/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.data;

import java.util.Objects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;

public class DamageData {
    private final float amount;
    private final long timestamp;
    private final String attackerName;
    private final String targetName;
    private final DamageType damageType;
    private final boolean isCritical;
    private final double x;
    private final double y;
    private final double z;

    public DamageData(float amount, Entity attacker, Entity target, DamageType damageType, boolean isCritical) {
        this.amount = amount;
        this.timestamp = System.currentTimeMillis();
        this.attackerName = attacker != null ? attacker.m_7755_().getString() : "Unknown";
        this.targetName = target != null ? target.m_7755_().getString() : "Unknown";
        this.damageType = damageType;
        this.isCritical = isCritical;
        if (target != null) {
            this.x = target.m_20185_();
            this.y = target.m_20186_();
            this.z = target.m_20189_();
        } else {
            this.z = 0.0;
            this.y = 0.0;
            this.x = 0.0;
        }
    }

    public DamageData(float amount, String attackerName, String targetName, DamageType damageType, boolean isCritical, double x, double y, double z) {
        this.amount = amount;
        this.timestamp = System.currentTimeMillis();
        this.attackerName = attackerName;
        this.targetName = targetName;
        this.damageType = damageType;
        this.isCritical = isCritical;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getAmount() {
        return this.amount;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getAttackerName() {
        return this.attackerName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public DamageType getDamageType() {
        return this.damageType;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public long getAgeInSeconds() {
        return (System.currentTimeMillis() - this.timestamp) / 1000L;
    }

    public boolean isRecent() {
        return this.getAgeInSeconds() < 30L;
    }

    public String getFormattedDescription() {
        String critText = this.isCritical ? " \u00a7c(CRIT!)" : "";
        return String.format("\u00a7f%s \u00a77dealt \u00a7%s%.1f \u00a77%s damage to \u00a7f%s%s", this.attackerName, this.isCritical ? "e" : "f", Float.valueOf(this.amount), this.damageType.getName().toLowerCase(), this.targetName, critText);
    }

    public String getDebugInfo() {
        return String.format("DamageData{amount=%.1f, attacker='%s', target='%s', type=%s, crit=%s, age=%ds, pos=(%.1f,%.1f,%.1f)}", Float.valueOf(this.amount), this.attackerName, this.targetName, this.damageType.name(), this.isCritical, this.getAgeInSeconds(), this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("%.1f %s damage (%s \u2192 %s)", Float.valueOf(this.amount), this.damageType.getName(), this.attackerName, this.targetName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DamageData that = (DamageData)obj;
        return Float.compare(that.amount, this.amount) == 0 && this.timestamp == that.timestamp && this.isCritical == that.isCritical && Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && Objects.equals(this.attackerName, that.attackerName) && Objects.equals(this.targetName, that.targetName) && this.damageType == that.damageType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Float.valueOf(this.amount), this.timestamp, this.attackerName, this.targetName, this.damageType, this.isCritical, this.x, this.y, this.z});
    }

    public static enum DamageType {
        MELEE(0xFF0000, "Melee", "Close-range physical damage"),
        RANGED(65280, "Ranged", "Long-range projectile damage"),
        MAGIC(255, "Magic", "Magical or spell damage"),
        FIRE(16729344, "Fire", "Fire and burn damage"),
        EXPLOSION(16747520, "Explosion", "Explosive damage"),
        FALL(9127187, "Fall", "Fall and environmental damage"),
        POISON(0x800080, "Poison", "Poison and toxic damage"),
        DROWNING(4286945, "Drowning", "Drowning and suffocation"),
        VOID(0, "Void", "Void and kill damage"),
        OTHER(0xFFFFFF, "Other", "Other types of damage");

        private final int color;
        private final String name;
        private final String description;

        private DamageType(int color, String name, String description) {
            this.color = color;
            this.name = name;
            this.description = description;
        }

        public int getColor() {
            return this.color;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public static DamageType fromDamageSource(DamageSource source) {
            if (source.m_276093_(DamageTypes.f_268464_) || source.m_276093_(DamageTypes.f_268566_)) {
                return MELEE;
            }
            if (source.m_276093_(DamageTypes.f_268739_) || source.m_276093_(DamageTypes.f_268714_)) {
                return RANGED;
            }
            if (source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268530_)) {
                return MAGIC;
            }
            if (source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268546_)) {
                return FIRE;
            }
            if (source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268448_)) {
                return EXPLOSION;
            }
            if (source.m_276093_(DamageTypes.f_268671_)) {
                return FALL;
            }
            if (source.m_276093_(DamageTypes.f_268493_)) {
                return POISON;
            }
            if (source.m_276093_(DamageTypes.f_268722_)) {
                return DROWNING;
            }
            if (source.m_276093_(DamageTypes.f_286979_) || source.m_276093_(DamageTypes.f_268724_)) {
                return VOID;
            }
            return OTHER;
        }
    }
}

