/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.data;

import net.minecraft.world.phys.Vec3;

public class FloatingNumber {
    private Vec3 position;
    private final float damage;
    private final int maxLifetime;
    private int lifetime;
    private final boolean isCritical;
    private final int color;

    public FloatingNumber(Vec3 position, float damage, int maxLifetime) {
        this.position = position;
        this.damage = damage;
        this.maxLifetime = maxLifetime;
        this.lifetime = 0;
        boolean bl = this.isCritical = damage >= 10.0f;
        this.color = this.isCritical ? 0xFF5555 : (damage >= 5.0f ? 0xFFAA00 : 0xFFFFFF);
    }

    public void tick() {
        ++this.lifetime;
        double upwardSpeed = 0.05;
        double fadeSpeed = 0.02;
        this.position = this.position.m_82520_((Math.random() - 0.5) * fadeSpeed, upwardSpeed, (Math.random() - 0.5) * fadeSpeed);
    }

    public boolean isExpired() {
        return this.lifetime >= this.maxLifetime;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public String getText() {
        if (this.isCritical) {
            return String.format("\u00a7l%.1f!", Float.valueOf(this.damage));
        }
        return String.format("%.1f", Float.valueOf(this.damage));
    }

    public int getColor() {
        return this.color;
    }

    public float getAlpha() {
        float progress = (float)this.lifetime / (float)this.maxLifetime;
        return Math.max(0.0f, 1.0f - progress);
    }

    public float getScale() {
        float progress = (float)this.lifetime / (float)this.maxLifetime;
        if (progress < 0.2f) {
            return 0.5f + progress * 2.5f;
        }
        return 1.0f;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public float getDamage() {
        return this.damage;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }
}

