/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.data;

import com.etema.dpsmeter.data.CombatSession;

public enum MetricType {
    CURRENT_DPS("Current DPS", "\u00a7aCurrent DPS", true),
    AVERAGE_DPS("Average DPS", "\u00a7bAverage DPS", true),
    TOTAL_DAMAGE("Total Damage", "\u00a7cTotal Damage", true),
    DAMAGE_TAKEN("Damage Taken", "\u00a7eDamage Taken", false),
    COMBAT_TIME("Combat Time", "\u00a7dCombat Time", true),
    TARGET_INFO("Target Info", "\u00a79Target Info", true),
    HIT_RATE("Hit Rate", "\u00a76Hit Rate", false),
    AVERAGE_HIT("Average Hit", "\u00a75Average Hit", false);

    private final String name;
    private final String displayName;
    private final boolean defaultVisible;

    private MetricType(String name, String displayName, boolean defaultVisible) {
        this.name = name;
        this.displayName = displayName;
        this.defaultVisible = defaultVisible;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isDefaultVisible() {
        return this.defaultVisible;
    }

    public String getFormattedValue(CombatSession session) {
        switch (this) {
            case CURRENT_DPS: {
                return String.format("%s: \u00a7f%.1f", this.displayName, Float.valueOf(session.getCurrentDps()));
            }
            case AVERAGE_DPS: {
                return String.format("%s: \u00a7f%.1f", this.displayName, Float.valueOf(session.getAverageDps()));
            }
            case TOTAL_DAMAGE: {
                return String.format("%s: \u00a7f%.0f", this.displayName, Float.valueOf(session.getTotalDamageDealt()));
            }
            case DAMAGE_TAKEN: {
                return String.format("%s: \u00a7f%.0f", this.displayName, Float.valueOf(session.getTotalDamageReceived()));
            }
            case COMBAT_TIME: {
                return String.format("%s: \u00a7f%.1fs", this.displayName, Float.valueOf((float)session.getCombatDuration() / 20.0f));
            }
            case HIT_RATE: {
                return String.format("%s: \u00a7f%.1f/s", this.displayName, Float.valueOf(session.getHitRate()));
            }
            case AVERAGE_HIT: {
                return String.format("%s: \u00a7f%.1f", this.displayName, Float.valueOf(session.getAverageDamagePerHit()));
            }
            case TARGET_INFO: {
                if (session.getCurrentTarget() != null) {
                    return String.format("%s: \u00a7f%s", this.displayName, session.getCurrentTarget().m_7755_().getString());
                }
                return String.format("%s: \u00a77None", this.displayName);
            }
        }
        return this.displayName + ": \u00a77N/A";
    }
}

