/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.data;

import com.etema.dpsmeter.config.DPSConfig;
import com.etema.dpsmeter.data.MetricType;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;

public class OverlayConfig {
    private static boolean overlayVisible = true;
    private static EnumSet<MetricType> visibleMetrics = EnumSet.noneOf(MetricType.class);

    public static boolean isOverlayVisible() {
        return !overlayVisible || (Boolean)DPSConfig.SHOW_OVERLAY.get() == false;
    }

    public static void toggleOverlay() {
        overlayVisible = !overlayVisible;
    }

    public static void setOverlayVisible(boolean visible) {
        overlayVisible = visible;
    }

    public static EnumSet<MetricType> getVisibleMetrics() {
        return EnumSet.copyOf(visibleMetrics);
    }

    public static void setVisibleMetrics(EnumSet<MetricType> metrics) {
        visibleMetrics = EnumSet.copyOf(metrics);
    }

    public static void toggleMetric(MetricType metric) {
        if (visibleMetrics.contains((Object)metric)) {
            visibleMetrics.remove((Object)metric);
        } else {
            visibleMetrics.add(metric);
        }
    }

    public static int getCalculatedX(int screenWidth) {
        return (int)((double)screenWidth * (Double)DPSConfig.OVERLAY_X.get());
    }

    public static int getCalculatedY(int screenHeight) {
        return (int)((double)screenHeight * (Double)DPSConfig.OVERLAY_Y.get());
    }

    public static float getOverlayScale() {
        return ((Double)DPSConfig.OVERLAY_SCALE.get()).floatValue();
    }

    public static void moveOverlay(int deltaX, int deltaY) {
        Minecraft mc = Minecraft.m_91087_();
        double currentX = (Double)DPSConfig.OVERLAY_X.get();
        double currentY = (Double)DPSConfig.OVERLAY_Y.get();
        double newX = currentX + (double)deltaX / (double)mc.m_91268_().m_85445_();
        double newY = currentY + (double)deltaY / (double)mc.m_91268_().m_85446_();
        newX = Math.max(0.0, Math.min(1.0, newX));
        newY = Math.max(0.0, Math.min(1.0, newY));
        DPSConfig.OVERLAY_X.set((Object)newX);
        DPSConfig.OVERLAY_Y.set((Object)newY);
        DPSConfig.SPEC.save();
    }

    public static void scaleOverlay(float delta) {
        double currentScale = (Double)DPSConfig.OVERLAY_SCALE.get();
        double newScale = Math.max(0.5, Math.min(3.0, currentScale + (double)delta));
        DPSConfig.OVERLAY_SCALE.set((Object)newScale);
        DPSConfig.SPEC.save();
    }

    static {
        for (MetricType metric : MetricType.values()) {
            if (!metric.isDefaultVisible()) continue;
            visibleMetrics.add(metric);
        }
    }
}

