/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.network;

import com.etema.dpsmeter.client.DPSOverlay;
import com.etema.dpsmeter.config.DPSConfig;
import com.etema.dpsmeter.data.CombatSession;
import com.etema.dpsmeter.data.DPSTracker;
import com.etema.dpsmeter.network.CombatUpdatePacket;
import com.etema.dpsmeter.network.DamageEventPacket;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientPacketHandler {
    public static void handleDamageEvent(DamageEventPacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (packet.getAttackerId().equals(mc.f_91074_.m_20148_())) {
            System.out.println("=== NETWORK DAMAGE EVENT ===");
            System.out.println("Player: " + mc.f_91074_.m_7755_().getString());
            System.out.println("Damage: " + packet.getDamage());
            System.out.println("Critical: " + packet.isCritical());
            LivingEntity target = ClientPacketHandler.findEntityByUUID(packet.getTargetId());
            if (target != null) {
                CombatSession session = DPSTracker.getSession();
                session.recordDamage(target, packet.getDamage());
                if (((Boolean)DPSConfig.SHOW_FLOATING_NUMBERS.get()).booleanValue()) {
                    DPSTracker.addFloatingNumber(target, packet.getDamage());
                }
                DPSOverlay.updatePlayerActivity();
            }
        }
    }

    public static void handleCombatUpdate(CombatUpdatePacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (packet.getPlayerId().equals(mc.f_91074_.m_20148_())) {
            System.out.println("=== NETWORK COMBAT UPDATE ===");
            System.out.println("Total Damage: " + packet.getTotalDamage());
            System.out.println("Current DPS: " + packet.getCurrentDps());
            System.out.println("Combat Active: " + packet.isCombatActive());
            DPSOverlay.updatePlayerActivity();
        }
    }

    private static LivingEntity findEntityByUUID(UUID uuid) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return null;
        }
        return mc.f_91073_.m_45976_(LivingEntity.class, mc.f_91074_.m_20191_().m_82400_(50.0)).stream().filter(entity -> entity.m_20148_().equals(uuid)).findFirst().orElse(null);
    }
}

