/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.network;

import com.etema.dpsmeter.network.ClientPacketHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class CombatUpdatePacket {
    private final UUID playerId;
    private final float totalDamage;
    private final float currentDps;
    private final boolean combatActive;

    public CombatUpdatePacket(UUID playerId, float totalDamage, float currentDps, boolean combatActive) {
        this.playerId = playerId;
        this.totalDamage = totalDamage;
        this.currentDps = currentDps;
        this.combatActive = combatActive;
    }

    public static void encode(CombatUpdatePacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.playerId);
        buf.writeFloat(packet.totalDamage);
        buf.writeFloat(packet.currentDps);
        buf.writeBoolean(packet.combatActive);
    }

    public static CombatUpdatePacket decode(FriendlyByteBuf buf) {
        return new CombatUpdatePacket(buf.m_130259_(), buf.readFloat(), buf.readFloat(), buf.readBoolean());
    }

    public static void handle(CombatUpdatePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientPacketHandler.handleCombatUpdate(packet));
        context.setPacketHandled(true);
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public float getTotalDamage() {
        return this.totalDamage;
    }

    public float getCurrentDps() {
        return this.currentDps;
    }

    public boolean isCombatActive() {
        return this.combatActive;
    }
}

