/*
 * Decompiled with CFR 0.152.
 */
package com.etema.dpsmeter.network;

import com.etema.dpsmeter.network.ClientPacketHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class DamageEventPacket {
    private final UUID attackerId;
    private final UUID targetId;
    private final float damage;
    private final boolean isCritical;
    private final long timestamp;

    public DamageEventPacket(UUID attackerId, UUID targetId, float damage, boolean isCritical) {
        this.attackerId = attackerId;
        this.targetId = targetId;
        this.damage = damage;
        this.isCritical = isCritical;
        this.timestamp = System.currentTimeMillis();
    }

    public static void encode(DamageEventPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.attackerId);
        buf.m_130077_(packet.targetId);
        buf.writeFloat(packet.damage);
        buf.writeBoolean(packet.isCritical);
        buf.writeLong(packet.timestamp);
    }

    public static DamageEventPacket decode(FriendlyByteBuf buf) {
        UUID attackerId = buf.m_130259_();
        UUID targetId = buf.m_130259_();
        float damage = buf.readFloat();
        boolean isCritical = buf.readBoolean();
        long timestamp = buf.readLong();
        DamageEventPacket packet = new DamageEventPacket(attackerId, targetId, damage, isCritical);
        return packet;
    }

    public static void handle(DamageEventPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientPacketHandler.handleDamageEvent(packet));
        context.setPacketHandled(true);
    }

    public UUID getAttackerId() {
        return this.attackerId;
    }

    public UUID getTargetId() {
        return this.targetId;
    }

    public float getDamage() {
        return this.damage;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

