/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry;

import magnusmakesgames.wizardry.blocks.WizardryBlocks;
import magnusmakesgames.wizardry.blocks.entity.WizardryBlockEntities;
import magnusmakesgames.wizardry.entities.ExplodingMushroomEntity;
import magnusmakesgames.wizardry.entities.WizardBossEntity;
import magnusmakesgames.wizardry.entities.WizardryEntities;
import magnusmakesgames.wizardry.helpers.ExplosionManager;
import magnusmakesgames.wizardry.helpers.HiddenRealm;
import magnusmakesgames.wizardry.items.WizardryItemGroup;
import magnusmakesgames.wizardry.items.WizardryItems;
import magnusmakesgames.wizardry.misc.WizardryLootTableModifiers;
import magnusmakesgames.wizardry.particles.WizardryParticles;
import magnusmakesgames.wizardry.screen.WizardryScreenHandlers;
import magnusmakesgames.wizardry.sounds.WizardrySounds;
import magnusmakesgames.wizardry.world.WizardryConfiguredFeatures;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_5132;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wizardry
implements ModInitializer {
    public static final String MOD_ID = "wizardry";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"wizardry");

    public void onInitialize() {
        LOGGER.info("Wizardry Mod Loading Initiated");
        WizardryBlockEntities.registerBlockEntities();
        WizardryScreenHandlers.registerScreenHandlers();
        WizardryItems.RegisterItems();
        WizardryItemGroup.RegisterItemGroups();
        WizardryLootTableModifiers.modifyLootTables();
        FlammableBlockRegistry.getDefaultInstance().add(WizardryBlocks.EXPLODING_FUNGUS, 20, 40);
        FlammableBlockRegistry.getDefaultInstance().add(WizardryBlocks.EXPLODING_FUNGUS_STEM, 10, 20);
        WizardryEntities.registerEntities();
        WizardrySounds.registerSounds();
        HiddenRealm.InitTick();
        HiddenRealm.HiddenRealmDeath();
        WizardryConfiguredFeatures.registerFeatures();
        FabricDefaultAttributeRegistry.register(WizardryEntities.FORGOTTEN_MAGE_ENTITY, (class_5132.class_5133)WizardBossEntity.createWizardBossAttributes());
        FabricDefaultAttributeRegistry.register(WizardryEntities.EXPLODING_MUSHROOM_ENTITY, (class_5132.class_5133)ExplodingMushroomEntity.createExplodingMushroomAttributes());
        ExplosionManager.InitTimedExplosionManager();
        WizardryParticles.register();
    }
}

