/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.entities;

import java.util.ArrayList;
import java.util.List;
import magnusmakesgames.wizardry.blocks.WizardryBlocks;
import magnusmakesgames.wizardry.helpers.CustomFunctions;
import magnusmakesgames.wizardry.helpers.ExplosionManager;
import magnusmakesgames.wizardry.helpers.ProjectileSpellHelper;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import magnusmakesgames.wizardry.sounds.WizardrySounds;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;

public class ExplodingMushroomEntity
extends class_1588 {
    private static final class_2940<Boolean> IS_EXPLODING = class_2945.method_12791(ExplodingMushroomEntity.class, (class_2941)class_2943.field_13323);
    public int explodingTime = 0;
    public final class_7094 explodingAnimationState = new class_7094();

    public ExplodingMushroomEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.8, false));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public static class_5132.class_5133 createExplodingMushroomAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 4.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 0.0).method_26868(class_5134.field_23723, 0.0).method_26868(class_5134.field_23722, 0.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_EXPLODING, (Object)false);
    }

    public void startExploding() {
        this.field_6011.method_12778(IS_EXPLODING, (Object)true);
        this.method_6092(new class_1293(class_1294.field_5909, 200, 5, false, false, false));
        this.method_37908().method_8396(null, this.method_24515(), WizardrySounds.MUSHROOM_ATTACK, class_3419.field_15251, 2.0f, ProjectileSpellHelper.getPitch(0.78f, 0.08f, this.field_5974));
        this.explodingTime = 0;
    }

    public boolean isExploding() {
        return (Boolean)this.field_6011.method_12789(IS_EXPLODING);
    }

    public static boolean canSpawn(class_1299<ExplodingMushroomEntity> type, class_5425 world, class_3730 reason, class_2338 pos, class_5819 random) {
        class_2680 blockBelow = world.method_8320(pos.method_10074());
        return blockBelow.method_26212((class_1922)world, pos.method_10074()) && world.method_8320(pos).method_26215();
    }

    protected void method_48565(float posDelta) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(posDelta * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.2f);
    }

    private void setupAnimationStates() {
        if (this.isExploding() && !this.explodingAnimationState.method_41327()) {
            this.explodingAnimationState.method_41322(this.field_6012);
        }
    }

    public void method_5773() {
        block3: {
            block2: {
                super.method_5773();
                if (this.method_37908().method_8608()) {
                    this.setupAnimationStates();
                    return;
                }
                if (!this.isExploding()) break block2;
                ++this.explodingTime;
                if (this.explodingTime < 10) break block3;
                this.explode();
                this.method_31472();
                break block3;
            }
            List<class_1309> nearbyEntities = CustomFunctions.getEntitiesInArea(this.method_37908(), this.method_19538(), 1.25);
            for (class_1309 entity : nearbyEntities) {
                class_1657 playerEntity;
                if (!(entity instanceof class_1657) || (playerEntity = (class_1657)entity).method_7337()) continue;
                this.startExploding();
                break;
            }
        }
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        this.explode();
        this.method_31472();
    }

    private void explode() {
        class_1937 world = this.method_37908();
        if (world.method_8608()) {
            return;
        }
        ExplosionManager.explode(world, this.method_24515(), (class_1309)this, (class_1297)this, 3.0f, 18.0f, 13.0f, new ArrayList<SpellItem>(), false);
        class_2338 pos = this.method_24515();
        world.method_8396(null, pos, WizardrySounds.FUNGAL_EXPLOSION, class_3419.field_15245, 2.0f, 1.0f);
        world.method_8396(null, pos, WizardrySounds.FUNGAL_EXPLOSION, class_3419.field_15245, 3.0f, 1.25f);
        world.method_8396(null, pos, class_3417.field_15152, class_3419.field_15245, 0.6f, 1.2f);
        ((class_3218)world).method_14199((class_2394)new class_2388(class_2398.field_11217, WizardryBlocks.EXPLODING_FUNGUS.method_9564()), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 16, 0.5, 0.5, 0.5, 0.5);
        ((class_3218)world).method_14199((class_2394)new class_2388(class_2398.field_11217, WizardryBlocks.EXPLODING_FUNGUS_STEM.method_9564()), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 12, 0.5, 0.5, 0.5, 0.5);
        ((class_3218)world).method_14199((class_2394)class_2398.field_11203, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 5, 0.4, 0.4, 0.4, 0.15);
        ((class_3218)world).method_14199((class_2394)class_2398.field_11236, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 5, 1.5, 1.5, 1.5, 0.15);
    }

    protected class_3414 method_6002() {
        return null;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14620;
    }
}

