/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.entities.spells;

import java.util.List;
import magnusmakesgames.wizardry.entities.WizardryEntities;
import magnusmakesgames.wizardry.entities.spells.SpellEntity;
import magnusmakesgames.wizardry.helpers.CustomFunctions;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import magnusmakesgames.wizardry.misc.WizardryDamageSources;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_3218;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.server.MinecraftServer;

public class MagicProjectileEntity
extends class_3857
implements SpellEntity {
    private String particleCommand = "minecraft:witch";
    private int hitDamage = 3;
    private class_2499 modifiers = new class_2499();
    private boolean isDuplicate = false;
    private float gravity = 0.03f;
    private float drag = 0.99f;
    private boolean canSelfDamage = false;
    SpellItem spellItem = null;
    private int lifetime = 0;
    private int maxLifetime = 100;
    class_1937 world = null;

    @Override
    public SpellItem getSpellItem() {
        return this.spellItem;
    }

    public void setCanSelfDamage(boolean value) {
        this.canSelfDamage = value;
    }

    @Override
    public void setSpellItem(SpellItem _spellItem) {
        this.spellItem = _spellItem;
    }

    public void setDuplicate(boolean value) {
        this.isDuplicate = value;
    }

    @Override
    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public MagicProjectileEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected class_1792 method_16942() {
        return this.method_16943().method_7909();
    }

    public MagicProjectileEntity(class_1299<? extends MagicProjectileEntity> entityType, class_1309 livingEntity, class_1937 world, class_243 position, int _maxLifetime) {
        super(entityType, livingEntity, world);
        this.method_33574(position);
        this.maxLifetime = _maxLifetime;
    }

    public MagicProjectileEntity(class_1309 livingEntity, class_1937 world, class_243 position, int _maxLifetime) {
        super(WizardryEntities.MAGIC_PROJECTILE, livingEntity, world);
        this.method_33574(position);
        this.maxLifetime = _maxLifetime;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10566("modifiers", (class_2520)this.modifiers);
        nbt.method_10569("hit_damage", this.hitDamage);
        nbt.method_10582("particle_command", this.particleCommand);
        nbt.method_10548("gravity", this.gravity);
        nbt.method_10548("drag", this.drag);
        nbt.method_10556("self_damage", this.canSelfDamage);
        nbt.method_10556("is_duplicate", this.isDuplicate);
    }

    public void setHitDamage(int dmg) {
        this.hitDamage = dmg;
    }

    public void setDrag(float _drag) {
        this.drag = _drag;
    }

    public void setParticleCommand(String _particleCommand) {
        this.particleCommand = _particleCommand;
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.modifiers = nbt.method_10554("modifiers", 9);
        this.hitDamage = nbt.method_10550("hit_damage");
        this.particleCommand = nbt.method_10558("particle_command");
        this.gravity = nbt.method_10583("gravity");
        this.drag = nbt.method_10583("drag");
        this.canSelfDamage = nbt.method_10577("self_damage");
        this.isDuplicate = nbt.method_10577("is_duplicate");
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    protected void method_24920(class_3965 blockHitResult) {
        this.method_31472();
        for (SpellItem mod : this.getModifiers()) {
            mod.OnHitBlock(this.method_37908(), (class_1297)this, (class_1309)this.method_24921(), blockHitResult.method_17777(), this.field_5974, this.method_5682(), List.of(this.getModifiers()));
        }
        super.method_24920(blockHitResult);
    }

    public void method_5773() {
        MinecraftServer server;
        if (this.world == null) {
            this.world = this.method_37908();
        }
        class_243 velocity = this.method_18798();
        this.method_18799(velocity.method_1021((double)this.drag));
        ++this.lifetime;
        if (this.world != null && (server = this.world.method_8503()) != null) {
            if (this.lifetime > 2 && !this.particleCommand.isEmpty()) {
                class_2168 source = server.method_3739().method_9217();
                String cmdPos = " " + this.method_23317() + " " + (this.method_23318() + (double)0.15f) + " " + this.method_23321();
                String cmdDimension = this.method_37908().method_27983().method_29177().toString();
                server.method_3734().method_44252(source, "execute in " + cmdDimension + " run particle " + this.particleCommand + cmdPos + " 0 0 0 0 1");
            }
            this.field_6007 = true;
        }
        for (SpellItem mod : this.getModifiers()) {
            mod.Tick(this.method_37908(), (class_1297)this, (class_1309)this.method_24921(), this.field_5974, this.method_5682(), List.of(this.getModifiers()));
        }
        super.method_5773();
        if (this.lifetime >= this.maxLifetime && this.maxLifetime != -1) {
            this.onExpiration(false);
            this.method_31472();
        }
    }

    protected void method_7488(class_239 hitResult) {
        SpellItem[] mods;
        this.onExpiration(true);
        for (SpellItem mod : mods = this.getModifiers()) {
            mod.OnCollision(this.method_37908(), (class_1297)this, (class_1309)this.method_24921(), this.field_5974, this.method_5682(), List.of(this.getModifiers()));
        }
        super.method_7488(hitResult);
    }

    @Override
    public void onExpiration(boolean didCollide) {
        SpellItem[] mods;
        if (this.method_5682() == null) {
            return;
        }
        for (SpellItem mod : mods = this.getModifiers()) {
            mod.OnExpire(this.method_37908(), (class_1297)this, (class_1309)this.method_24921(), this.field_5974, this.method_5682(), List.of(this.getModifiers()));
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        if (this.method_37908().method_8608()) {
            return;
        }
        if (this.method_24921() != null) {
            class_1297 class_12972;
            boolean isOwner;
            boolean bl = isOwner = entityHitResult.method_17782() == this.method_24921();
            if (this.canSelfDamage) {
                isOwner = false;
            }
            if (!isOwner && (class_12972 = entityHitResult.method_17782()) instanceof class_1309) {
                class_1309 hitEntity = (class_1309)class_12972;
                float finalDamage = CustomFunctions.getFinalDamage((float)this.hitDamage, this.getModifiers());
                class_243 oldVelocity = hitEntity.method_18798();
                if (finalDamage > 0.0f) {
                    hitEntity.method_5643(WizardryDamageSources.magicSpell((class_3218)this.method_37908(), (class_1309)this.method_24921()), finalDamage);
                }
                hitEntity.method_18799(oldVelocity);
                hitEntity.field_6037 = true;
                boolean piercing = false;
                for (SpellItem modifier : this.getModifiers()) {
                    if (modifier.OnHitEntity(this.method_37908(), (class_1297)this, (class_1309)this.method_24921(), hitEntity, this.field_5974, this.method_5682(), List.of(this.getModifiers()))) continue;
                    piercing = true;
                }
                if (!piercing) {
                    this.method_31472();
                }
            }
        }
    }

    @Override
    public void applySpellModifiers(class_2499 value) {
        this.modifiers = value;
    }

    @Override
    public class_2499 getModifierNbt() {
        return this.modifiers;
    }

    public void setGravity(float newGravity) {
        this.gravity = newGravity;
    }

    protected float method_7490() {
        return this.getSpellGravity(this.gravity);
    }
}

