/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.entities.spells;

import java.util.ArrayList;
import java.util.List;
import magnusmakesgames.wizardry.entities.WizardryEntities;
import magnusmakesgames.wizardry.entities.spells.MagicProjectileEntity;
import magnusmakesgames.wizardry.items.WizardryItems;
import magnusmakesgames.wizardry.items.custom.SpellEggItem;
import magnusmakesgames.wizardry.items.custom.SpellInfo;
import magnusmakesgames.wizardry.items.custom.SpellType;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector3f;

public class MagicProjectileEntityWithTrigger
extends MagicProjectileEntity {
    public List<SpellItem> containedSpells = new ArrayList<SpellItem>();
    public boolean isTimer = false;
    public boolean isEgg = false;

    public MagicProjectileEntityWithTrigger(class_1299<? extends MagicProjectileEntityWithTrigger> entityType, class_1937 world) {
        super(entityType, world);
    }

    public MagicProjectileEntityWithTrigger(class_1309 livingEntity, class_1937 world, class_243 position, int _maxLifetime) {
        super(WizardryEntities.MAGIC_PROJECTILE_W_TRIGGER, livingEntity, world, position, _maxLifetime);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        class_2499 spellListNbt = (class_2499)nbt.method_10580("contained_spells");
        ArrayList<SpellItem> spellList = new ArrayList<SpellItem>();
        if (spellListNbt != null) {
            for (class_2520 spell : spellListNbt) {
                spellList.add(WizardryItems.GetSpellItem(spell.method_10714()));
            }
            this.containedSpells = spellList;
        }
        this.isTimer = nbt.method_10577("is_timer");
        this.isEgg = nbt.method_10577("is_egg");
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_2499 spellList = new class_2499();
        if (this.containedSpells != null) {
            for (SpellItem spell : this.containedSpells) {
                spellList.add((Object)class_2519.method_23256((String)spell.getSpellInfo().id));
            }
            nbt.method_10566("contained_spells", (class_2520)spellList);
            nbt.method_10556("is_timer", this.isTimer);
            nbt.method_10556("is_egg", this.isEgg);
        }
    }

    private float[] getPitchYawFromNormal(class_243 normal) {
        float pitch = (float)(-(Math.asin(normal.field_1351) * 57.29577951308232));
        float yaw = (float)(Math.atan2(-normal.field_1352, normal.field_1350) * 57.29577951308232);
        return new float[]{pitch, yaw};
    }

    @Override
    public void onExpiration(boolean didCollide) {
        super.onExpiration(false);
        if (this.isEgg && !didCollide) {
            this.dropAsEgg();
            return;
        }
        if (this.isTimer && !didCollide) {
            this.castContainedSpells(this.method_18798().method_1029());
        }
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        boolean dropEgg = this.shouldDropEgg();
        if (!dropEgg) {
            super.method_7454(entityHitResult);
            class_243 normal = entityHitResult.method_17784().method_1020(this.method_19538()).method_1029();
            this.castContainedSpells(normal.method_22882());
        } else {
            this.dropAsEgg();
        }
    }

    private boolean shouldDropEgg() {
        return this.isEgg && this.method_18798().method_1033() < (double)0.275f;
    }

    @Override
    protected void method_24920(class_3965 blockHitResult) {
        boolean dropEgg = this.shouldDropEgg();
        if (!dropEgg) {
            super.method_24920(blockHitResult);
            Vector3f faceNormal = blockHitResult.method_17780().method_23955();
            class_243 normal = new class_243((double)faceNormal.x(), (double)faceNormal.y(), (double)faceNormal.z()).method_1029();
            class_243 incoming = this.method_18798().method_1029();
            class_243 reflected = incoming.method_1020(normal.method_1021(2.0 * incoming.method_1026(normal))).method_1029();
            this.castContainedSpells(reflected);
        } else {
            this.dropAsEgg();
        }
    }

    private void dropAsEgg() {
        if (this.method_37908().method_8608()) {
            return;
        }
        class_1799 stack = SpellEggItem.GetSpellEggStack(this);
        if (stack != null) {
            this.world.method_8649((class_1297)new class_1542(this.world, this.method_23317(), this.method_23318(), this.method_23321(), stack));
        }
        this.method_31472();
    }

    private void castContainedSpells(class_243 normal) {
        class_1297 class_12972;
        if (this.containedSpells != null && (class_12972 = this.method_24921()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            float[] pitchYaw = this.getPitchYawFromNormal(normal);
            this.CastSpell(this.method_37908(), livingEntity, this.method_5682(), this.method_19538(), pitchYaw[0], pitchYaw[1], 1.0f);
        }
    }

    public void CastSpell(class_1937 world, class_1309 user, MinecraftServer server, class_243 castPos, float castPitch, float castYaw, float castSpread) {
        boolean noCast = true;
        for (SpellItem spell : this.containedSpells) {
            if (spell == null || spell.getSpellInfo().spellType == SpellType.ProjectileModifier || spell.getSpellInfo().spellType == SpellType.None) continue;
            noCast = false;
            break;
        }
        if (noCast) {
            return;
        }
        ArrayList<SpellItem> modifiers = new ArrayList<SpellItem>();
        for (SpellItem castingSpell : this.containedSpells) {
            if (castingSpell == null) continue;
            SpellInfo castingSpellInfo = castingSpell.getSpellInfo();
            if (castingSpellInfo.spellType == SpellType.Other && !castingSpell.equals(WizardryItems.ALPHA) && !castingSpell.equals(WizardryItems.GAMMA)) {
                castSpread = Math.max(castSpread, 0.0f);
                castingSpell.Cast(world, user, class_5819.method_43047(), server, castPos, castPitch, castYaw, castSpread, modifiers);
            }
            castSpread += castingSpellInfo.spread;
            if (castingSpellInfo.spellType == SpellType.ProjectileModifier) {
                SpellItem modifier = WizardryItems.GetSpellItem(castingSpellInfo.id);
                if (modifier == null) continue;
                modifiers.add(modifier);
                continue;
            }
            if (castingSpellInfo.spellType == SpellType.Projectile) {
                castSpread = Math.max(castSpread, 0.0f);
                castingSpell.Cast(world, user, class_5819.method_43047(), server, castPos, castPitch, castYaw, castSpread, modifiers);
                continue;
            }
            if (castingSpellInfo.spellType != SpellType.Utility) continue;
            castSpread = Math.max(castSpread, 0.0f);
            castPos = castingSpell.GetCastPosMod(castPos, user, castPitch, castYaw, castSpread);
            castingSpell.Cast(world, user, class_5819.method_43047(), server, castPos, castPitch, castYaw, castSpread, modifiers);
        }
    }
}

