/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.helpers;

import java.util.List;
import magnusmakesgames.wizardry.entities.spells.MagicProjectileEntity;
import magnusmakesgames.wizardry.items.WizardryItems;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import magnusmakesgames.wizardry.sounds.WizardrySounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class ProjectileSpellHelper {
    public static float getProjectileSpeed(float base, List<SpellItem> modifiers) {
        float speed = base;
        for (SpellItem mod : modifiers) {
            speed += mod.GetSpeedMod(speed);
        }
        return speed;
    }

    public static int getProjectileLifetime(int base, List<SpellItem> modifiers) {
        int lifetime = base;
        for (SpellItem mod : modifiers) {
            lifetime += mod.GetLifetimeMod(base);
        }
        return lifetime;
    }

    public static float getPitch(float value, float randomness, class_5819 random) {
        return value + (random.method_43057() - 0.5f) * randomness;
    }

    public static void PlayCastSound(class_1937 world, class_243 pos) {
        world.method_8396(null, class_2338.method_49638((class_2374)pos), WizardrySounds.CAST_PROJECTILE, class_3419.field_15248, 0.45f, ProjectileSpellHelper.getPitch(1.5f, 0.1f, class_5819.method_43047()));
    }

    public static void setVelocity(MagicProjectileEntity projectile, float pitch, float yaw, float roll, float speed, float divergence) {
        float f = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        float g = -class_3532.method_15374((float)((pitch + roll) * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        projectile.method_7485(f, g, h, speed, divergence);
    }

    public static MagicProjectileEntity CastProjectileDuplicate(class_1937 world, class_1309 caster, MinecraftServer server, class_1792 rendererItem, SpellItem item, int damage, String particleCommand, class_243 pos, float pitch, float yaw, int maxLifetime, List<SpellItem> modifiers) {
        return ProjectileSpellHelper.CastProjectileDuplicate(world, caster, server, rendererItem, item, damage, particleCommand, pos, pitch, yaw, maxLifetime, modifiers, true, false);
    }

    public static MagicProjectileEntity CastProjectileDuplicate(class_1937 world, class_1309 caster, MinecraftServer server, class_1792 rendererItem, SpellItem item, int damage, String particleCommand, class_243 pos, float pitch, float yaw, int maxLifetime, List<SpellItem> modifiers, boolean playSound, boolean canSelfDamage) {
        float speed = 1.0f;
        if (playSound) {
            ProjectileSpellHelper.PlayCastSound(world, pos);
        }
        MagicProjectileEntity projectile = new MagicProjectileEntity(caster, world, pos, maxLifetime);
        ProjectileSpellHelper.setVelocity(projectile, pitch, yaw, 0.0f, speed, 0.0f);
        projectile.method_7432((class_1297)caster);
        projectile.method_16940(new class_1799((class_1935)rendererItem, 1));
        projectile.setParticleCommand(particleCommand);
        projectile.setHitDamage(damage);
        projectile.setModifiers(modifiers);
        projectile.setDuplicate(true);
        projectile.setSpellItem(item);
        projectile.setCanSelfDamage(canSelfDamage);
        world.method_8649((class_1297)projectile);
        return projectile;
    }

    public static class_243 AddCastOffset(class_243 castPos, class_1309 user, float castSpread) {
        class_243 finalCastPos = castPos;
        class_243 playerPos = new class_243(user.method_23317(), user.method_23320() - (double)0.1f, user.method_23321());
        float distance = 1.0f;
        double sm = 0.0172275;
        class_5819 random = class_5819.method_43047();
        double spreadX = random.method_43385(0.0, sm * (double)castSpread);
        double spreadY = random.method_43385(0.0, sm * (double)castSpread);
        double spreadZ = random.method_43385(0.0, sm * (double)castSpread);
        finalCastPos = castPos.method_1019(user.method_5828(1.0f).method_1031(spreadX, spreadY, spreadZ).method_1029().method_1021((double)distance));
        return finalCastPos;
    }

    public static void CastDiggingBase(class_1937 world, class_1309 caster, class_243 castPos, class_2338 blockPos, float maxHardness, List<SpellItem> modifiers) {
        if (!(caster instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)caster;
        class_2680 state = world.method_8320(blockPos);
        if (state.method_26215() || state.method_26214((class_1922)world, blockPos) < 0.0f) {
            return;
        }
        if (modifiers.contains((SpellItem)WizardryItems.PRESERVING_PROJECTILE)) {
            return;
        }
        float hardness = state.method_26214((class_1922)world, blockPos);
        if (hardness > maxHardness) {
            return;
        }
        if (!world.method_8505(player, blockPos)) {
            return;
        }
        world.method_22352(blockPos, true);
    }
}

