/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.items.custom.spells.items.projectile;

import java.util.List;
import magnusmakesgames.wizardry.entities.spells.MagicProjectileEntity;
import magnusmakesgames.wizardry.helpers.CustomFunctions;
import magnusmakesgames.wizardry.helpers.ProjectileSpellHelper;
import magnusmakesgames.wizardry.items.custom.SpellInfo;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import magnusmakesgames.wizardry.misc.WizardryDamageSources;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class HealingBoltSpell
extends SpellItem {
    public HealingBoltSpell(class_1792.class_1793 settings, SpellInfo spellInfo) {
        super(settings, spellInfo);
    }

    @Override
    public String[] GetAdditionalTooltips() {
        return new String[]{"Dmg. Healing: -4"};
    }

    @Override
    public void Cast(class_1937 world, class_1309 caster, class_5819 random, MinecraftServer server, class_243 castPos, float castPitch, float castYaw, float spread, List<SpellItem> modifiers) {
        float speed = ProjectileSpellHelper.getProjectileSpeed(2.0f, modifiers);
        int lifetime = ProjectileSpellHelper.getProjectileLifetime(30, modifiers);
        MagicProjectileEntity projectile = new MagicProjectileEntity(caster, world, castPos, lifetime);
        ProjectileSpellHelper.setVelocity(projectile, castPitch += random.method_43057() * spread - spread / 2.0f, castYaw += random.method_43057() * spread - spread / 2.0f, 0.0f, speed, 0.0f);
        projectile.method_7432((class_1297)caster);
        projectile.method_16940(new class_1799((class_1935)class_1802.field_19049, 1));
        projectile.setParticleCommand("wizardry:healing_particle");
        projectile.setHitDamage(-999);
        projectile.setGravity(0.02f);
        projectile.setModifiers(modifiers);
        projectile.setDuplicate(false);
        projectile.setSpellItem(this);
        projectile.setCanSelfDamage(true);
        world.method_8649((class_1297)projectile);
    }

    @Override
    public void CastDuplicate(class_1937 world, class_1297 entity, class_1309 caster, class_5819 random, MinecraftServer server, class_243 castPos, float castPitch, float castYaw, float spread, List<SpellItem> modifiers) {
        ProjectileSpellHelper.CastProjectileDuplicate(world, caster, server, class_1802.field_19049, this, 0, "wizardry:healing_particle", castPos, castPitch, castYaw, 80, modifiers, true, true);
    }

    @Override
    public boolean OnHitEntity(class_1937 world, class_1297 entity, class_1309 caster, class_1309 hitEntity, class_5819 random, MinecraftServer server, List<SpellItem> modifiers) {
        if (world.method_8608()) {
            return super.OnHitEntity(world, entity, caster, hitEntity, random, server, modifiers);
        }
        class_2168 source = server.method_3739().method_9217();
        String cmdPos = " " + hitEntity.method_23317() + " " + (hitEntity.method_23320() - 0.25) + " " + hitEntity.method_23321();
        String cmdDimension = world.method_27983().method_29177().toString();
        server.method_3734().method_44252(source, "execute in " + cmdDimension + " run particle wizardry:healing_particle" + cmdPos + " 0.25 0.25 0.25 1.5 10");
        float healingAmount = CustomFunctions.getFinalDamage(-4.0f, modifiers);
        if (healingAmount < 0.0f) {
            hitEntity.method_6025(-healingAmount);
        } else if (healingAmount > 0.0f) {
            hitEntity.method_5643(WizardryDamageSources.magicSpell((class_3218)world, caster), healingAmount);
        }
        return super.OnHitEntity(world, entity, caster, hitEntity, random, server, modifiers);
    }
}

