/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.items.custom.spells.items.projectile;

import java.util.List;
import magnusmakesgames.wizardry.entities.spells.MagicProjectileEntity;
import magnusmakesgames.wizardry.helpers.CustomFunctions;
import magnusmakesgames.wizardry.helpers.ProjectileSpellHelper;
import magnusmakesgames.wizardry.items.custom.SpellInfo;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import magnusmakesgames.wizardry.misc.WizardryDamageSources;
import magnusmakesgames.wizardry.sounds.WizardrySounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class PlasmaBeamSpell
extends SpellItem {
    public PlasmaBeamSpell(class_1792.class_1793 settings, SpellInfo spellInfo) {
        super(settings, spellInfo);
    }

    @Override
    public String[] GetAdditionalTooltips() {
        return new String[]{"Dmg. Plasma: 4"};
    }

    @Override
    public void Cast(class_1937 world, class_1309 caster, class_5819 random, MinecraftServer server, class_243 castPos, float castPitch, float castYaw, float spread, List<SpellItem> modifiers) {
        float speed = 0.001f;
        int lifetime = ProjectileSpellHelper.getProjectileLifetime(80, modifiers);
        MagicProjectileEntity projectile = new MagicProjectileEntity(caster, world, castPos, lifetime);
        ProjectileSpellHelper.setVelocity(projectile, castPitch += random.method_43057() * spread - spread / 2.0f, castYaw += random.method_43057() * spread - spread / 2.0f, 0.0f, speed, 0.0f);
        projectile.method_7432((class_1297)caster);
        projectile.method_16940(new class_1799((class_1935)class_1802.field_8162, 1));
        projectile.setParticleCommand("");
        projectile.setHitDamage(4);
        projectile.setModifiers(modifiers);
        projectile.setDuplicate(false);
        projectile.setGravity(0.0f);
        projectile.setDrag(1.010101f);
        projectile.setSpellItem(this);
        world.method_8649((class_1297)projectile);
        world.method_8449(null, (class_1297)projectile, class_7923.field_41172.method_47983((Object)WizardrySounds.PLASMA_BEAM), class_3419.field_15248, 0.4f, 1.0f, 0L);
    }

    @Override
    public void Tick(class_1937 world, class_1297 entity, class_1309 caster, class_5819 random, MinecraftServer server, List<SpellItem> modifiers) {
        int startOffset;
        if (entity.field_6012 % 79 == 0) {
            world.method_8449(null, entity, class_7923.field_41172.method_47983((Object)WizardrySounds.PLASMA_BEAM), class_3419.field_15248, 0.4f, 1.0f, 0L);
        }
        if (entity.method_18798().method_1033() > 1.0) {
            entity.method_18799(entity.method_18798().method_1021(0.7));
        }
        entity.field_6037 = true;
        int maxRaySteps = 50;
        float rayStepSize = 0.1f;
        float collisionScale = 0.1f;
        for (int i = startOffset = 6; i < maxRaySteps; ++i) {
            class_243 rayPos = entity.method_19538().method_1019(entity.method_18798().method_1029().method_1021((double)((float)i * rayStepSize)));
            CustomFunctions.SpawnParticles(world, rayPos, "wizardry:plasma_particle", new class_243(0.05, 0.05, 0.05), 0.0f, 2);
            boolean didCollide = world.method_8320(class_2338.method_49638((class_2374)rayPos)).method_51367();
            class_238 box = new class_238(rayPos.field_1352 - (double)collisionScale, rayPos.field_1351 - (double)collisionScale, rayPos.field_1350 - (double)collisionScale, rayPos.field_1352 + (double)collisionScale, rayPos.field_1351 + (double)collisionScale, rayPos.field_1350 + (double)collisionScale);
            List entities = world.method_8390(class_1309.class, box, e -> e.method_5805() && !e.method_7325() && e != entity);
            for (class_1309 entity1 : entities) {
                didCollide = true;
                entity1.method_5643(WizardryDamageSources.plasmaBeam((class_3218)world, caster), 4.0f);
            }
            if (didCollide) break;
        }
    }

    @Override
    public boolean OnHitEntity(class_1937 world, class_1297 entity, class_1309 caster, class_1309 hitEntity, class_5819 random, MinecraftServer server, List<SpellItem> modifiers) {
        return false;
    }

    @Override
    public void CastDuplicate(class_1937 world, class_1297 entity, class_1309 caster, class_5819 random, MinecraftServer server, class_243 castPos, float castPitch, float castYaw, float spread, List<SpellItem> modifiers) {
        MagicProjectileEntity projectile = ProjectileSpellHelper.CastProjectileDuplicate(world, caster, server, class_1802.field_8162, this, 4, "wizardry:plasma_particle", castPos, castPitch, castYaw, 60, modifiers, false, false);
        projectile.method_18799(projectile.method_18798().method_1029().method_1021((double)0.001f));
        projectile.setGravity(0.0f);
        projectile.setDrag(1.010101f);
    }
}

