/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.items.custom.wand;

import java.util.ArrayList;
import java.util.List;
import magnusmakesgames.wizardry.items.WizardryItems;
import magnusmakesgames.wizardry.items.custom.SpellInfo;
import magnusmakesgames.wizardry.items.custom.SpellType;
import magnusmakesgames.wizardry.items.custom.WandInfo;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import magnusmakesgames.wizardry.items.custom.spells.items.SpellInstance;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class WandItem
extends class_1792 {
    public final WandInfo wandInfo;

    public WandItem(class_1792.class_1793 settings, WandInfo info) {
        super(settings);
        this.wandInfo = info;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        List<SpellInstance> spells = WandItem.getSpellsFromWand(stack);
        if (!spells.isEmpty()) {
            Object remainingCasts = "";
            for (SpellInstance spell : spells) {
                if (spell.spell == null || spell.spell.getSpellInfo().maxCasts <= 0) continue;
                remainingCasts = (String)remainingCasts + spell.remainingCasts + "/" + spell.spell.getSpellInfo().maxCasts + ", ";
            }
            if (((String)remainingCasts).length() > 2) {
                tooltip.add((class_2561)class_2561.method_43470((String)((String)remainingCasts).substring(0, ((String)remainingCasts).length() - 2)).method_27692(class_124.field_1076));
            }
        }
        tooltip.add((class_2561)class_2561.method_43470((String)("Max Mana: " + this.wandInfo.maxMana)).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43470((String)("Mana recharge/s: " + this.wandInfo.manaRecharge)).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43470((String)("Cast Delay: " + this.wandInfo.castDelay + "s")).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43470((String)("Recharge Time: " + this.wandInfo.rechargeTime + "s")).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43470((String)("Spell Slots: " + this.wandInfo.maxSlots)).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43470((String)("Spread: " + this.wandInfo.spread + "\u00b0")).method_27692(class_124.field_1080));
        super.method_7851(stack, world, tooltip, context);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        player.method_6019(hand);
        return class_1271.method_22428((Object)player.method_5998(hand));
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!world.field_9236) {
            MinecraftServer server = world.method_8503();
            if (server != null && user.method_5805()) {
                this.CastSpell(world, user, server, stack);
            }
            super.method_7852(world, user, stack, 72000);
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        int currentMana;
        super.method_7888(stack, world, entity, slot, selected);
        if (world.method_8608()) {
            return;
        }
        class_2487 nbt = stack.method_7948();
        int n = currentMana = nbt.method_10545("mana") ? nbt.method_10550("mana") : this.wandInfo.maxMana;
        if (currentMana < this.wandInfo.maxMana) {
            int currentManaRechargePortion = nbt.method_10545("mana_recharge_portion") ? nbt.method_10550("mana_recharge_portion") : 0;
            int manaToRecharge = (int)Math.floor((currentManaRechargePortion += this.wandInfo.manaRecharge) / 20);
            currentManaRechargePortion -= manaToRecharge * 20;
            if ((currentMana += manaToRecharge) > this.wandInfo.maxMana) {
                currentMana = this.wandInfo.maxMana;
            }
            nbt.method_10569("mana", currentMana);
            nbt.method_10569("mana_recharge_portion", currentManaRechargePortion);
        }
    }

    public void CastSpell(class_1937 world, class_1309 user, MinecraftServer server, class_1799 itemStack) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            long currentTime = world.method_8510();
            class_2487 nbt = itemStack.method_7948();
            long lastUseTick = nbt.method_10537("last_use_tick");
            long currentCastDelay = nbt.method_10550("current_cast_delay");
            List<SpellInstance> spells = WandItem.getSpellsFromWand(itemStack);
            boolean spellDrained = false;
            boolean noCast = true;
            for (SpellInstance spell : spells) {
                if (spell.spell == null || spell.spell.getSpellInfo().spellType == SpellType.ProjectileModifier || spell.spell.getSpellInfo().spellType == SpellType.None) continue;
                noCast = false;
                break;
            }
            if (noCast) {
                return;
            }
            if (currentTime - lastUseTick >= currentCastDelay) {
                int remainingCasts = 1;
                int spellsCast = 0;
                ArrayList<SpellItem> modifiers = new ArrayList<SpellItem>();
                ArrayList multicastModifiers = new ArrayList();
                int castDelay = Math.round(this.wandInfo.castDelay * 20.0f);
                int maxSpells = spells.size();
                int rechargeTime = nbt.method_10550("recharge_time");
                boolean doRecharge = false;
                class_243 castPos = new class_243(user.method_23317(), user.method_23320() - (double)0.1f, user.method_23321());
                float castPitch = user.method_36455();
                float castYaw = user.method_36454();
                float castSpread = this.wandInfo.spread;
                while (remainingCasts > 0 && spellsCast < maxSpells) {
                    ArrayList finalModifiers;
                    int currentSpellIndex;
                    --remainingCasts;
                    ++spellsCast;
                    int n = currentSpellIndex = nbt.method_10545("current_spell_index") ? nbt.method_10550("current_spell_index") : 0;
                    if (currentSpellIndex >= maxSpells) {
                        currentSpellIndex = -1;
                        doRecharge = true;
                        nbt.method_10569("current_spell_index", currentSpellIndex);
                        continue;
                    }
                    currentSpellIndex = Math.max(currentSpellIndex, 0);
                    SpellInstance castingSpell = spells.get(currentSpellIndex);
                    if (castingSpell.spell == null) {
                        ++remainingCasts;
                        if (++currentSpellIndex >= maxSpells) {
                            currentSpellIndex = -1;
                            doRecharge = true;
                        }
                        nbt.method_10569("current_spell_index", currentSpellIndex);
                        continue;
                    }
                    SpellInfo castingSpellInfo = castingSpell.spell.getSpellInfo();
                    int currentMana = nbt.method_10545("mana") ? nbt.method_10550("mana") : this.wandInfo.maxMana;
                    int manaCost = castingSpellInfo.manaCost;
                    spellDrained = false;
                    if (castingSpellInfo.maxCasts > 0) {
                        int spellRemainingCasts = ((class_2487)((class_2499)nbt.method_10580("Spells")).method_10534(currentSpellIndex)).method_10550("remainingCasts");
                        if (spellRemainingCasts <= 0) {
                            spellDrained = true;
                        }
                        if (spellRemainingCasts <= 0 || currentMana - manaCost < 0) {
                            ++remainingCasts;
                            if (++currentSpellIndex >= maxSpells) {
                                currentSpellIndex = -1;
                                remainingCasts = 0;
                                doRecharge = true;
                            }
                            nbt.method_10569("current_spell_index", currentSpellIndex);
                            continue;
                        }
                        class_2487 newSpellInfo = (class_2487)((class_2499)nbt.method_10580("Spells")).method_10534(currentSpellIndex);
                        newSpellInfo.method_10569("remainingCasts", spellRemainingCasts - 1);
                        class_2499 spells2 = nbt.method_10554("Spells", 10);
                        spells2.method_10606(currentSpellIndex, (class_2520)newSpellInfo);
                        nbt.method_10566("Spells", (class_2520)spells2);
                    }
                    ++currentSpellIndex;
                    if (currentMana - manaCost < 0) {
                        if (++currentSpellIndex >= maxSpells) {
                            currentSpellIndex = -1;
                            remainingCasts = 0;
                            doRecharge = true;
                        }
                        nbt.method_10569("current_spell_index", currentSpellIndex);
                        continue;
                    }
                    if ((currentMana -= manaCost) > this.wandInfo.maxMana) {
                        currentMana = this.wandInfo.maxMana;
                    }
                    nbt.method_10569("mana", currentMana);
                    if (currentSpellIndex >= maxSpells) {
                        currentSpellIndex = -1;
                        remainingCasts = 0;
                        doRecharge = true;
                    }
                    nbt.method_10569("current_spell_index", currentSpellIndex);
                    if (castingSpellInfo.spellType == SpellType.Other) {
                        if (castingSpell.spell.equals(WizardryItems.GAMMA)) {
                            castingSpell = spells.get(nbt.method_10550("last_spell_index"));
                        } else if (castingSpell.spell.equals(WizardryItems.ALPHA)) {
                            castingSpell = spells.get(nbt.method_10550("first_spell_index"));
                        }
                        if (castingSpell.spell.equals(WizardryItems.GAMMA) || castingSpell.spell.equals(WizardryItems.ALPHA)) continue;
                        if (castingSpell.spell.equals(WizardryItems.WAND_REFRESHER)) {
                            currentSpellIndex = -1;
                            nbt.method_10569("current_spell_index", currentSpellIndex);
                            remainingCasts = 0;
                            doRecharge = true;
                        } else {
                            ArrayList finalModifiers2 = new ArrayList(modifiers);
                            finalModifiers2.addAll(multicastModifiers);
                            castSpread = Math.max(castSpread, 0.0f);
                            castingSpell.spell.Cast(world, user, class_5819.method_43047(), server, castPos, castPitch, castYaw, castSpread, finalModifiers2);
                            modifiers.clear();
                        }
                    }
                    class_2170 commandManager = server.method_3734();
                    class_2168 commandSource = server.method_3739();
                    castDelay += Math.round(castingSpellInfo.castDelay * 20.0f);
                    rechargeTime += Math.round(castingSpellInfo.rechargeTime * 20.0f);
                    castSpread += castingSpellInfo.spread;
                    if (castingSpellInfo.spellType == SpellType.ProjectileModifier) {
                        ++remainingCasts;
                        SpellItem modifier = WizardryItems.GetSpellItem(castingSpellInfo.id);
                        if (modifier == null) continue;
                        modifiers.add(modifier);
                        continue;
                    }
                    if (castingSpellInfo.spellType == SpellType.Multicast) {
                        remainingCasts += castingSpell.spell.GetLifetimeMod(0);
                        multicastModifiers = new ArrayList(modifiers);
                        modifiers.clear();
                        continue;
                    }
                    if (castingSpellInfo.spellType == SpellType.Projectile) {
                        castSpread = Math.max(castSpread, 0.0f);
                        finalModifiers = new ArrayList(modifiers);
                        finalModifiers.addAll(multicastModifiers);
                        if (!castingSpell.spell.HasTrigger()) {
                            castingSpell.spell.Cast(world, (class_1309)player, class_5819.method_43047(), server, castPos, castPitch, castYaw, castSpread, finalModifiers);
                        } else {
                            ArrayList<SpellItem> containedSpells = new ArrayList<SpellItem>();
                            int triggerCasts = 1;
                            --currentSpellIndex;
                            class_2499 spells2 = nbt.method_10554("Spells", 10);
                            while (triggerCasts > 0) {
                                --triggerCasts;
                                if (++currentSpellIndex >= maxSpells) {
                                    currentSpellIndex = -1;
                                    triggerCasts = 0;
                                    doRecharge = true;
                                    nbt.method_10569("current_spell_index", currentSpellIndex);
                                    continue;
                                }
                                SpellInstance triggerSpell = spells.get(currentSpellIndex);
                                if (triggerSpell.spell == null) {
                                    ++triggerCasts;
                                    continue;
                                }
                                if (triggerSpell.spell.getSpellInfo().manaCost > currentMana) continue;
                                SpellType triggerSpellType = triggerSpell.spell.getSpellInfo().spellType;
                                if (triggerSpell.spell.getSpellInfo().maxCasts > 0) {
                                    if (triggerSpell.remainingCasts <= 0) continue;
                                    --triggerSpell.remainingCasts;
                                    class_2487 newSpellInfo = (class_2487)((class_2499)nbt.method_10580("Spells")).method_10534(currentSpellIndex);
                                    newSpellInfo.method_10569("remainingCasts", triggerSpell.remainingCasts);
                                    spells2.method_10606(currentSpellIndex, (class_2520)newSpellInfo);
                                }
                                if (triggerSpellType.equals((Object)SpellType.ProjectileModifier)) {
                                    ++triggerCasts;
                                } else if (triggerSpellType.equals((Object)SpellType.Utility)) {
                                    if (triggerSpell.spell.FreeCast()) {
                                        ++triggerCasts;
                                    }
                                } else if (triggerSpellType.equals((Object)SpellType.Multicast)) {
                                    triggerCasts += triggerSpell.spell.GetLifetimeMod(0);
                                } else if (triggerSpellType.equals((Object)SpellType.Other)) {
                                    if (triggerSpell.spell.equals(WizardryItems.GAMMA)) {
                                        triggerSpell = spells.get(nbt.method_10550("last_spell_index"));
                                    } else if (triggerSpell.spell.equals(WizardryItems.ALPHA)) {
                                        triggerSpell = spells.get(nbt.method_10550("first_spell_index"));
                                    }
                                    if (triggerSpell.spell.equals(WizardryItems.GAMMA) || triggerSpell.spell.equals(WizardryItems.ALPHA)) continue;
                                }
                                SpellInfo triggerSpellInfo = triggerSpell.spell.getSpellInfo();
                                currentMana -= triggerSpellInfo.manaCost;
                                castDelay += Math.round(triggerSpellInfo.castDelay * 20.0f);
                                rechargeTime += Math.round(triggerSpellInfo.rechargeTime * 20.0f);
                                containedSpells.add(triggerSpell.spell);
                            }
                            nbt.method_10566("Spells", (class_2520)spells2);
                            nbt.method_10569("mana", currentMana);
                            castingSpell.spell.CastWithTrigger(world, (class_1309)player, class_5819.method_43047(), server, castPos, castPitch, castYaw, castSpread, finalModifiers, containedSpells);
                            nbt.method_10569("current_spell_index", currentSpellIndex + 1);
                        }
                        modifiers.clear();
                        continue;
                    }
                    if (castingSpellInfo.spellType == SpellType.Utility) {
                        castSpread = Math.max(castSpread, 0.0f);
                        finalModifiers = new ArrayList(modifiers);
                        finalModifiers.addAll(multicastModifiers);
                        castPos = castingSpell.spell.GetCastPosMod(castPos, user, castPitch, castYaw, castSpread);
                        castingSpell.spell.Cast(world, (class_1309)player, class_5819.method_43047(), server, castPos, castPitch, castYaw, castSpread, finalModifiers);
                        if (castingSpell.spell.FreeCast()) {
                            ++remainingCasts;
                            continue;
                        }
                        modifiers.clear();
                        continue;
                    }
                    if (castingSpellInfo.spellType == SpellType.Other) continue;
                    ++remainingCasts;
                }
                int delay = castDelay;
                if (spellDrained) {
                    nbt.method_10569("current_spell_index", nbt.method_10550("current_spell_index") + 1);
                }
                if (nbt.method_10550("current_spell_index") > nbt.method_10550("last_spell_index")) {
                    nbt.method_10569("current_spell_index", 0);
                    doRecharge = true;
                }
                if (doRecharge) {
                    delay = Math.max(castDelay, rechargeTime);
                    rechargeTime = Math.round(this.wandInfo.rechargeTime * 20.0f);
                }
                nbt.method_10569("current_cast_delay", delay);
                nbt.method_10544("last_use_tick", world.method_8510());
                nbt.method_10548("recharge_time", (float)rechargeTime);
            }
        }
    }

    public static List<SpellInstance> getSpellsFromWand(class_1799 wandStack) {
        class_2487 wandNbt;
        ArrayList<SpellInstance> spells = new ArrayList<SpellInstance>();
        if (wandStack.method_7985() && (wandNbt = wandStack.method_7969()) != null && wandNbt.method_10573("Spells", 9)) {
            class_2499 spellList = wandNbt.method_10554("Spells", 10);
            for (class_2520 element : spellList) {
                if (!(element instanceof class_2487)) continue;
                class_2487 spellNbt = (class_2487)element;
                SpellItem spell = WizardryItems.GetSpellItem(spellNbt.method_10558("id"));
                if (spell != null) {
                    if (spell.getSpellInfo().maxCasts > 0) {
                        int remainingCasts = spellNbt.method_10550("remainingCasts");
                        spells.add(new SpellInstance(spell, remainingCasts));
                        continue;
                    }
                    spells.add(new SpellInstance(spell, 0));
                    continue;
                }
                spells.add(new SpellInstance(null, 0));
            }
        }
        return spells;
    }
}

