/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.blocks.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import magnusmakesgames.wizardry.blocks.entity.ImplementedInventory;
import magnusmakesgames.wizardry.blocks.entity.WizardryBlockEntities;
import magnusmakesgames.wizardry.helpers.ItemGiver;
import magnusmakesgames.wizardry.items.WizardryItems;
import magnusmakesgames.wizardry.items.custom.SpellInfo;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import magnusmakesgames.wizardry.items.custom.spells.items.SpellInstance;
import magnusmakesgames.wizardry.items.custom.wand.WandItem;
import magnusmakesgames.wizardry.screen.WandbuildingTableScreenHandler;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class WandbuildingTableBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private int slotCount = 1;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)this.slotCount, (Object)class_1799.field_8037);
    private final Set<class_3222> viewers = new HashSet<class_3222>();
    private class_3222 closeTable = null;
    private boolean blockRemoved = false;
    private final Set<class_3222> updatingPlayers = new HashSet<class_3222>();

    public Set<class_3222> getViewers() {
        return this.viewers;
    }

    public void addViewer(class_3222 player) {
        this.viewers.add(player);
    }

    public void removeViewer(class_3222 player) {
        this.viewers.remove(player);
    }

    public void setCloseTable(class_3222 player) {
        this.closeTable = player;
    }

    public void closeAllViewers() {
        this.updatingPlayers.clear();
        this.blockRemoved = true;
        for (class_3222 player : this.getViewers()) {
            if (!(player.field_7512 instanceof WandbuildingTableScreenHandler)) continue;
            player.method_7346();
        }
        this.viewers.clear();
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public boolean isUpdatingScreen(class_3222 player) {
        return this.updatingPlayers.contains(player);
    }

    public void removeUpdatingPlayer(class_3222 player) {
        this.updatingPlayers.remove(player);
    }

    private void UpdateInventoryUI() {
        for (class_3222 player : this.getViewers()) {
            this.updatingPlayers.add(player);
            player.method_7346();
            player.method_17355((class_3908)this);
        }
    }

    public void setSlotCountNoUIRefresh(int newSlotCount) {
        if (newSlotCount != this.slotCount) {
            class_2371 newInventory = class_2371.method_10213((int)newSlotCount, (Object)class_1799.field_8037);
            for (int i = 0; i < Math.min(newSlotCount, this.inventory.size()); ++i) {
                newInventory.set(i, (Object)((class_1799)this.inventory.get(i)));
            }
            this.inventory = newInventory;
            this.slotCount = newSlotCount;
        }
    }

    public void setSlotCount(int newSlotCount) {
        if (this.blockRemoved) {
            return;
        }
        if (newSlotCount != this.slotCount) {
            this.setSlotCountNoUIRefresh(newSlotCount);
            this.method_5431();
            this.UpdateInventoryUI();
        }
    }

    public WandbuildingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(WizardryBlockEntities.WANDBUILDING_TABLE_BLOCK_ENTITY, pos, state);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("slot_count", this.slotCount);
        class_1262.method_5426((class_2487)nbt, this.inventory);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        int newSlotCount = nbt.method_10550("slot_count");
        this.setSlotCount(1);
        class_2371 tempInv = class_2371.method_10213((int)newSlotCount, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, (class_2371)tempInv);
        this.inventory = class_2371.method_10213((int)1, (Object)((class_1799)tempInv.get(0)));
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Wandbuilding Table");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new WandbuildingTableScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (slot >= this.inventory.size()) {
            return class_1799.field_8037;
        }
        return (class_1799)this.getItems().get(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        class_1799 previousStack = this.method_5438(slot);
        this.getItems().set(slot, (Object)stack);
        if (!class_1799.method_7973((class_1799)previousStack, (class_1799)stack)) {
            this.onSlotChanged(slot, stack);
        }
    }

    @Override
    public class_1799 method_5441(int slot) {
        class_1799 value = class_1262.method_5428(this.getItems(), (int)slot);
        this.onSlotChanged(slot, class_1799.field_8037);
        return value;
    }

    @Override
    public class_1799 method_5434(int slot, int count) {
        class_1799 result = class_1262.method_5430(this.getItems(), (int)slot, (int)count);
        if (!result.method_7960()) {
            this.method_5431();
        }
        this.onSlotChanged(slot, class_1799.field_8037);
        return result;
    }

    public void onSlotChanged(int slot, class_1799 newStack) {
        if (slot == 0 && this.field_11863 != null) {
            if (!newStack.method_7960()) {
                class_1792 class_17922 = newStack.method_7909();
                if (class_17922 instanceof WandItem) {
                    WandItem wandItem = (WandItem)class_17922;
                    class_2487 nbt = newStack.method_7969();
                    if (nbt != null) {
                        this.setSlotCount(1 + wandItem.wandInfo.maxSlots);
                        this.InsertSpellsFromWand(newStack);
                    }
                } else {
                    this.ClearSpells();
                }
            } else {
                this.ClearSpells();
            }
        }
    }

    private void ClearSpells() {
        for (class_3222 viewer : this.getViewers()) {
            class_1799 stackToGive = viewer.field_7512.method_34255();
            if (stackToGive.method_7960()) {
                stackToGive = (class_1799)this.inventory.get(0);
            }
            if (!stackToGive.method_7960()) {
                ItemGiver.TryGiveItemStack(viewer, stackToGive);
                viewer.field_7512.method_34254(class_1799.field_8037);
                this.inventory.set(0, (Object)class_1799.field_8037);
            }
            viewer.method_7346();
        }
        this.setSlotCountNoUIRefresh(1);
        this.method_5431();
    }

    private void InsertSpellsFromWand(class_1799 stack) {
        List<SpellInstance> spells = WandItem.getSpellsFromWand(stack);
        for (int i = 0; i < this.getSlotCount() - 1 && i < spells.size() && i + 1 < this.getSlotCount(); ++i) {
            if (spells.get(i) == null || spells.get((int)i).spell == null) continue;
            class_1799 spellStack = new class_1799((class_1935)WizardryItems.GetSpellItem(spells.get((int)i).spell.getSpellInfo().id), 1);
            class_2487 nbt = spellStack.method_7948();
            nbt.method_10569("remainingCasts", spells.get((int)i).remainingCasts);
            spellStack.method_7980(nbt);
            this.method_5447(i + 1, spellStack);
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state1) {
        class_1799 wandStack;
        class_1792 class_17922;
        if (world == null) {
            return;
        }
        if (this.closeTable != null) {
            this.closeTable.method_7346();
            this.closeTable.field_7498.method_37420();
            this.closeTable = null;
        }
        if ((class_17922 = (wandStack = (class_1799)this.inventory.get(0)).method_7909()) instanceof WandItem) {
            WandItem wandItem = (WandItem)class_17922;
            class_2487 wandNbt = wandStack.method_7948();
            class_2499 spellList = new class_2499();
            int firstSpellIndex = -1;
            int lastSpellIndex = -1;
            int maxSpells = wandItem.wandInfo.maxSlots;
            for (int i = 0; i < maxSpells && i + 1 < this.inventory.size(); ++i) {
                class_1799 spellStack = (class_1799)this.inventory.get(i + 1);
                class_2487 spellNbt = new class_2487();
                class_1792 class_17923 = spellStack.method_7909();
                if (class_17923 instanceof SpellItem) {
                    SpellItem spellItem = (SpellItem)class_17923;
                    SpellInfo spellInfo = spellItem.getSpellInfo();
                    spellNbt.method_10582("id", spellInfo.id);
                    spellNbt.method_10569("remainingCasts", spellItem.getRemainingCasts(spellStack));
                    if (firstSpellIndex == -1) {
                        firstSpellIndex = i;
                    }
                    lastSpellIndex = i;
                }
                spellList.add((Object)spellNbt);
            }
            wandNbt.method_10566("Spells", (class_2520)spellList);
            wandNbt.method_10569("current_spell_index", 0);
            wandNbt.method_10569("first_spell_index", firstSpellIndex);
            wandNbt.method_10569("last_spell_index", lastSpellIndex);
            wandStack.method_7980(wandNbt);
        }
    }
}

