/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.entities.ai;

import java.util.EnumSet;
import java.util.List;
import magnusmakesgames.wizardry.entities.WizardBossEntity;
import magnusmakesgames.wizardry.helpers.CustomFunctions;
import magnusmakesgames.wizardry.misc.WizardryDamageSources;
import magnusmakesgames.wizardry.sounds.WizardrySounds;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1371;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public class WizardBossLaserAttackGoal
extends class_1371 {
    private final WizardBossEntity entity;
    private class_1309 target;
    private int cooldownTicks = 110;
    private int animationTicks = 0;
    private final int cooldownDuration = 100;
    private final int laserDuration = 50;
    private final int attackStartTime = 23;
    private static int laserDamage = 9;

    public WizardBossLaserAttackGoal(WizardBossEntity entity) {
        super((class_1308)entity);
        this.entity = entity;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
    }

    public boolean method_6264() {
        class_1309 livingEntity = this.entity.method_5968();
        if (this.entity.method_6510()) {
            return false;
        }
        if (livingEntity == null || !livingEntity.method_5805()) {
            return false;
        }
        if (livingEntity.method_5739((class_1297)this.entity) > 40.0f) {
            return false;
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
            return false;
        }
        if (this.entity.method_6057((class_1297)livingEntity)) {
            this.target = livingEntity;
            return true;
        }
        return false;
    }

    public void method_6269() {
        super.method_6269();
        this.animationTicks = 73;
        this.entity.setAttackState((byte)2);
        this.entity.method_5942().method_6340();
    }

    public void method_6268() {
        if (this.entity.method_37908().method_8608()) {
            return;
        }
        if (this.animationTicks > 0) {
            --this.animationTicks;
            if (this.animationTicks == 50) {
                this.entity.method_37908().method_8396(null, class_2338.method_49638((class_2374)this.getAttackPosition()), WizardrySounds.WIZARD_LASER, class_3419.field_15251, 2.0f, 1.0f);
            }
            if (this.animationTicks <= 50) {
                this.attack();
            }
        }
    }

    private class_243 getAttackPosition() {
        class_243 localOffset = new class_243(-1.4, 4.4, 3.4);
        float yawDeg = this.entity.method_43078();
        double yawRad = Math.toRadians(yawDeg);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        double x = localOffset.field_1352 * cos - localOffset.field_1350 * sin;
        double z = localOffset.field_1352 * sin + localOffset.field_1350 * cos;
        class_243 rotatedOffset = new class_243(x, localOffset.field_1351, z);
        return this.entity.method_19538().method_1019(rotatedOffset);
    }

    private void attack() {
        class_1937 class_19372 = this.entity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_243 targetPos = this.target.method_19538().method_1031(0.0, 1.0, 0.0);
        class_243 attackPos = this.getAttackPosition();
        int maxRaySteps = 480;
        float rayStepSize = 0.1f;
        float collisionScale = 0.05f;
        for (int i = 0; i < maxRaySteps; ++i) {
            class_243 rayPos = attackPos.method_1019(targetPos.method_1020(attackPos).method_1029().method_1021((double)((float)i * rayStepSize)));
            CustomFunctions.SpawnParticles((class_1937)world, rayPos, "wizardry:laser_particle", new class_243(0.0, 0.0, 0.0), 0.0f, 1);
            boolean didCollide = !world.method_8320(class_2338.method_49638((class_2374)rayPos)).method_45474();
            class_238 box = new class_238(rayPos.field_1352 - (double)collisionScale, rayPos.field_1351 - (double)collisionScale, rayPos.field_1350 - (double)collisionScale, rayPos.field_1352 + (double)collisionScale, rayPos.field_1351 + (double)collisionScale, rayPos.field_1350 + (double)collisionScale);
            List entities = world.method_8390(class_1309.class, box, e -> e.method_5805() && !e.method_7325() && e != this.entity);
            for (class_1309 entity1 : entities) {
                didCollide = true;
                entity1.method_5643(WizardryDamageSources.wizardLaser(world, (class_1309)this.entity), (float)laserDamage);
            }
            if (!didCollide) continue;
            CustomFunctions.SpawnParticles((class_1937)world, rayPos, "small_flame", new class_243(0.1, 0.1, 0.1), 0.02f, 3);
            break;
        }
    }

    public void method_6270() {
        this.entity.setAttackState((byte)0);
        this.cooldownTicks = 100;
        this.animationTicks = 0;
        this.target = null;
        super.method_6270();
    }

    public boolean method_6266() {
        return this.animationTicks > 0 && this.target != null && this.target.method_5805();
    }
}

