/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.entities.ai;

import java.util.EnumSet;
import java.util.List;
import magnusmakesgames.wizardry.entities.WizardBossEntity;
import magnusmakesgames.wizardry.helpers.CustomFunctions;
import magnusmakesgames.wizardry.sounds.WizardrySounds;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1371;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public class WizardBossShockwaveAttackGoal
extends class_1371 {
    private final WizardBossEntity entity;
    private class_1309 target;
    private int cooldownTicks = 0;
    private int animationTicks = 0;
    private final int cooldownDuration = 120;
    private final int animationDuration = 30;

    public WizardBossShockwaveAttackGoal(WizardBossEntity entity) {
        super((class_1308)entity);
        this.entity = entity;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
    }

    public boolean method_6264() {
        class_1309 livingEntity = this.entity.method_5968();
        if (this.entity.method_6510()) {
            return false;
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
            return false;
        }
        if (livingEntity == null || !livingEntity.method_5805()) {
            return false;
        }
        if (livingEntity.method_5739((class_1297)this.entity) > 7.0f) {
            return false;
        }
        this.target = livingEntity;
        return true;
    }

    public void method_6269() {
        super.method_6269();
        this.animationTicks = 30;
        this.entity.setAttackState((byte)4);
        this.entity.method_5942().method_6340();
        class_243 pos = this.entity.method_19538();
        this.entity.method_37908().method_8396(null, class_2338.method_49638((class_2374)pos), WizardrySounds.SHOCKWAVE_CHARGE, class_3419.field_15251, 2.5f, 1.25f);
    }

    public void method_6268() {
        if (this.entity.method_37908().method_8608()) {
            return;
        }
        if (this.animationTicks > 0) {
            --this.animationTicks;
            if (this.animationTicks == 0) {
                this.attack();
            }
        }
    }

    private class_243 getAttackPosition() {
        class_243 localOffset = new class_243(0.0, 5.0, 2.0);
        float yawDeg = this.entity.method_43078();
        double yawRad = Math.toRadians(yawDeg);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        double x = localOffset.field_1352 * cos - localOffset.field_1350 * sin;
        double z = localOffset.field_1352 * sin + localOffset.field_1350 * cos;
        class_243 rotatedOffset = new class_243(x, localOffset.field_1351, z);
        return this.entity.method_19538().method_1019(rotatedOffset);
    }

    private void attack() {
        class_1937 class_19372 = this.entity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_243 attackPos = this.getAttackPosition();
        world.method_14199((class_2394)class_2398.field_38908, attackPos.field_1352, attackPos.field_1351, attackPos.field_1350, 20, 2.5, 2.5, 2.5, 0.5);
        this.entity.method_37908().method_8396(null, class_2338.method_49638((class_2374)attackPos), WizardrySounds.SHOCKWAVE, class_3419.field_15251, 3.0f, 1.0f);
        List<class_1309> nearbyEntities = CustomFunctions.getEntitiesInArea((class_1937)world, attackPos, 6.5);
        for (class_1309 entity1 : nearbyEntities) {
            if (entity1.equals((Object)this.entity)) continue;
            class_243 dir = entity1.method_19538().method_1020(this.entity.method_19538()).method_1029();
            entity1.method_18799(new class_243(dir.field_1352 * 2.0, 0.5, dir.field_1350 * 2.0));
            entity1.field_6037 = true;
            world.method_14199((class_2394)class_2398.field_23114, entity1.method_23317(), entity1.method_23318(), entity1.method_23321(), 15, 0.5, 0.5, 0.5, 0.25);
            float healing = entity1 instanceof class_1657 ? 20.0f : 5.0f;
            this.entity.method_6025(healing);
        }
    }

    public void method_6270() {
        this.entity.setAttackState((byte)0);
        this.cooldownTicks = 120;
        this.animationTicks = 0;
        this.target = null;
        super.method_6270();
    }

    public boolean method_6266() {
        return this.animationTicks > 0 && this.target != null && this.target.method_5805();
    }
}

