/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.entities.spells;

import java.util.List;
import magnusmakesgames.wizardry.Wizardry;
import magnusmakesgames.wizardry.entities.WizardryEntities;
import magnusmakesgames.wizardry.entities.spells.SpellEntity;
import magnusmakesgames.wizardry.helpers.CustomFunctions;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1540;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class SpellFallingBlockEntity
extends class_1540
implements SpellEntity {
    SpellItem spellItem = null;
    private class_2499 modifiers = new class_2499();
    private boolean isDuplicate = false;
    private class_2680 block = class_2246.field_10102.method_9564();
    private class_1309 owner;
    private int remainingLifetime = 100;
    private int groundedTime = 0;
    private final float hitDamage = 15.0f;

    @Override
    public SpellItem getSpellItem() {
        return this.spellItem;
    }

    @Override
    public void setSpellItem(SpellItem _spellItem) {
        this.spellItem = _spellItem;
    }

    public SpellFallingBlockEntity(class_1299<? extends class_1540> type, class_1937 world) {
        super(type, world);
    }

    public void setDuplicate(boolean value) {
        this.isDuplicate = value;
    }

    public SpellFallingBlockEntity(class_1937 world, double x, double y, double z, class_1309 caster, int lifetime, class_2680 _block) {
        super(WizardryEntities.SPELL_FALLING_BLOCK, world);
        this.method_5814(x, y, z);
        double d = world.field_9229.method_43058() * 2.0 * Math.PI;
        this.method_18800(-Math.sin(d) * 0.02, 0.2, -Math.cos(d) * 0.02);
        this.owner = caster;
        this.remainingLifetime = lifetime;
        this.block = _block;
    }

    public class_1309 getOwner() {
        return this.owner;
    }

    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.block));
        nbt.method_10566("modifiers", (class_2520)this.modifiers);
        nbt.method_10556("is_duplicate", this.isDuplicate);
        nbt.method_10569("remaining_lifetime", this.remainingLifetime);
    }

    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.block = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)nbt.method_10562("BlockState"));
        this.modifiers = nbt.method_10554("modifiers", 9);
        this.isDuplicate = nbt.method_10577("is_duplicate");
        this.remainingLifetime = nbt.method_10550("remaining_lifetime");
    }

    @Override
    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public static int getLaggyTicks(MinecraftServer server) {
        long[] tickLengths = server.field_4573;
        int totalAboveThreshold = 0;
        int threshold = 90000000;
        for (long ns : tickLengths) {
            if (ns <= (long)threshold) continue;
            ++totalAboveThreshold;
        }
        return totalAboveThreshold;
    }

    public void method_5773() {
        class_1937 world = this.method_37908();
        if (!world.method_8608()) {
            int laggyTicks = SpellFallingBlockEntity.getLaggyTicks(((class_3218)world).method_8503());
            Wizardry.LOGGER.info("lag: " + laggyTicks);
            if (laggyTicks > 10) {
                world.method_8652(this.method_24515(), this.block, 3);
                this.method_31472();
                return;
            }
            if (this.method_23318() > (double)(world.method_31605() + 10)) {
                this.method_31472();
                return;
            }
        }
        for (SpellItem mod : this.getModifiers()) {
            mod.Tick(this.method_37908(), (class_1297)this, this.getOwner(), this.field_5974, this.method_5682(), List.of(this.getModifiers()));
        }
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, (double)(-this.getGravity()), 0.0));
        }
        this.field_6007 = true;
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_18799(this.method_18798().method_1021(0.98));
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.7, -0.5, 0.7));
        }
        --this.remainingLifetime;
        --this.groundedTime;
        if (this.groundedTime < 0) {
            this.groundedTime = 0;
        }
        if (this.method_18798().method_1033() > 0.75) {
            if (!world.method_8608()) {
                List<class_1309> entities = CustomFunctions.getEntitiesInArea(world, this.method_19538(), 0.5);
                this.damageEntities(entities);
            }
        } else if (this.method_18798().method_1033() < 0.5 && !world.method_8320(this.method_24515().method_10059((class_2382)new class_2338(0, 1, 0))).method_45474()) {
            for (SpellItem mod : this.getModifiers()) {
                mod.OnHitBlock(this.method_37908(), (class_1297)this, this.getOwner(), this.method_24515(), this.field_5974, this.method_5682(), List.of(this.getModifiers()));
            }
            this.groundedTime += 2;
            if (this.groundedTime >= 22 && !world.method_8608()) {
                for (SpellItem mod : this.getModifiers()) {
                    mod.OnExpire(this.method_37908(), (class_1297)this, this.getOwner(), this.field_5974, this.method_5682(), List.of(this.getModifiers()));
                }
                this.method_31472();
                world.method_8652(this.method_24515(), this.block, 3);
            }
        }
        if (this.remainingLifetime <= 0) {
            for (SpellItem mod : this.getModifiers()) {
                mod.OnExpire(this.method_37908(), (class_1297)this, this.getOwner(), this.field_5974, this.method_5682(), List.of(this.getModifiers()));
            }
            this.method_31472();
        }
    }

    private void damageEntities(List<class_1309> entities) {
        if (entities.isEmpty()) {
            return;
        }
        float finalDamage = CustomFunctions.getFinalDamage(this.hitDamage, this.getModifiers());
        for (class_1309 entity : entities) {
            for (SpellItem mod : this.getModifiers()) {
                mod.OnHitEntity(this.method_37908(), (class_1297)this, this.getOwner(), entity, this.field_5974, this.method_5682(), List.of(this.getModifiers()));
            }
            if (!(finalDamage > 0.0f)) continue;
            entity.method_5643(this.method_48923().method_48798((class_1297)this.getOwner()), finalDamage);
        }
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    @Override
    public void applySpellModifiers(class_2499 value) {
        this.modifiers = value;
    }

    @Override
    public class_2499 getModifierNbt() {
        return this.modifiers;
    }

    protected float getGravity() {
        return this.getSpellGravity(0.04f);
    }

    public class_2680 method_6962() {
        return this.block;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.block = class_2248.method_9531((int)packet.method_11166());
        this.field_23807 = true;
        double d = packet.method_11175();
        double e = packet.method_11174();
        double f = packet.method_11176();
        this.method_5814(d, e, f);
        this.method_6963(this.method_24515());
    }
}

