/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import magnusmakesgames.wizardry.helpers.QueuedExplosion;
import magnusmakesgames.wizardry.helpers.QueuedExplosionSound;
import magnusmakesgames.wizardry.items.WizardryItems;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2530;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5575;

public class ExplosionManager {
    private static final List<QueuedExplosion> explosionQueue = new ArrayList<QueuedExplosion>();

    public static boolean queueHasPosition(class_2338 pos) {
        for (QueuedExplosion queuedExplosion : explosionQueue) {
            if (queuedExplosion.position != pos) continue;
            return true;
        }
        return false;
    }

    public static void InitTimedExplosionManager() {
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (explosionQueue.isEmpty()) {
                return;
            }
            for (int i = 0; i < explosionQueue.size(); ++i) {
                if (i > explosionQueue.size() - 1) {
                    return;
                }
                QueuedExplosion entry = explosionQueue.get(i);
                if (entry.world != world) continue;
                class_2338 pos = entry.position;
                int ticksLeft = entry.ticksRemaining - 1;
                if (ticksLeft <= 0) {
                    ExplosionManager.explode((class_1937)world, pos, entry.radius, entry.centerDamage, entry.rimDamage, entry.dontBreak, entry.sound, entry.owner);
                    explosionQueue.remove(i);
                    --i;
                    continue;
                }
                entry.ticksRemaining = ticksLeft;
            }
        });
    }

    public static void QueueExplosion(class_1937 world, int tickDelay, class_2338 pos, int radius, float centerDamage, float rimDamage, QueuedExplosionSound sound) {
        explosionQueue.add(new QueuedExplosion(world, tickDelay, pos, radius, centerDamage, rimDamage, false, sound, null));
    }

    public static void QueueExplosion(class_1937 world, int tickDelay, class_2338 pos, int radius, float centerDamage, float rimDamage, boolean dontBreak, QueuedExplosionSound sound, class_1309 owner) {
        explosionQueue.add(new QueuedExplosion(world, tickDelay, pos, radius, centerDamage, rimDamage, dontBreak, sound, owner));
    }

    public static void explode(class_1937 world, class_2338 pos, class_1309 owner, class_1297 explodingEntity, float explosionRadius, float centerDamage, float rimDamage, List<SpellItem> modifiers, boolean doEffects) {
        float finalRadius = explosionRadius;
        float finalCenterDmg = centerDamage;
        float finalRimDmg = rimDamage;
        boolean harmless = false;
        for (SpellItem mod : modifiers) {
            if (mod.equals(WizardryItems.HARMLESS_SHOT)) {
                harmless = true;
                continue;
            }
            finalCenterDmg += mod.GetDamageMod(centerDamage);
            finalRimDmg += mod.GetDamageMod(centerDamage) / 2.0f;
            finalRadius += mod.GetDamageMod(centerDamage) / 4.0f;
        }
        float maxHardness = 6.0f;
        List<Object> explosionBlocks = !modifiers.contains((SpellItem)WizardryItems.PRESERVING_PROJECTILE) ? ExplosionManager.getExplosionBlocks(world, pos, Math.round(finalRadius), maxHardness) : new ArrayList();
        if (world.method_8503() == null) {
            return;
        }
        if (doEffects) {
            float pitch = 1.5f;
            float volume = 2.0f;
            float sizeDiff = finalRadius - explosionRadius;
            volume += sizeDiff / 2.0f;
            volume = Math.max(volume, 1.0f);
            world.method_8396(null, pos, class_3417.field_15152, class_3419.field_15245, volume, pitch /= 1.0f + sizeDiff / 2.0f);
            ((class_3218)world).method_14199((class_2394)class_2398.field_11236, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 8, 0.5, 0.5, 0.5, 0.2);
        }
        float finalRadius1 = finalRadius;
        world.method_8503().execute(() -> {
            HashMap<class_2248, Integer> blockBreakCount = new HashMap<class_2248, Integer>();
            int dropThreshold = 32;
            for (class_2338 pos1 : explosionBlocks) {
                if (world.method_8320(pos1).method_26204() instanceof class_2530) {
                    class_1541 tntEntity = new class_1541(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, owner);
                    tntEntity.method_6967(5);
                    world.method_8649((class_1297)tntEntity);
                } else {
                    class_2680 state = world.method_8320(pos1);
                    class_2586 be = world.method_8321(pos1);
                    if (world.method_8409().method_43057() < 0.3f) {
                        boolean shouldDrop;
                        int count = blockBreakCount.getOrDefault(state.method_26204(), 0);
                        blockBreakCount.put(state.method_26204(), count + 1);
                        boolean bl = shouldDrop = count < dropThreshold;
                        if (ExplosionManager.getItemEntityCount((class_3218)world) > 1000) {
                            shouldDrop = false;
                        }
                        if (shouldDrop) {
                            class_2248.method_9610((class_2680)state, (class_1936)world, (class_2338)pos1, (class_2586)be);
                        }
                    }
                    if ((double)world.method_8409().method_43057() <= (double)0.2f / Math.pow(finalRadius1, 1.15) && doEffects) {
                        ((class_3218)world).method_14199((class_2394)class_2398.field_11236, (double)pos1.method_10263() + 0.5, (double)pos1.method_10264() + 0.5, (double)pos1.method_10260() + 0.5, 2, 0.9, 0.9, 0.9, 0.2);
                    }
                }
                world.method_8652(pos1, class_2246.field_10124.method_9564(), 7);
            }
        });
        class_243 center = class_243.method_24953((class_2382)pos);
        List nearbyEntities = world.method_8390(class_1309.class, new class_238(center.field_1352 - (double)finalRadius, center.field_1351 - (double)finalRadius, center.field_1350 - (double)finalRadius, center.field_1352 + (double)finalRadius, center.field_1351 + (double)finalRadius, center.field_1350 + (double)finalRadius), entity -> entity.method_5805() && !entity.method_7325());
        if (!harmless) {
            for (class_1297 entity2 : nearbyEntities) {
                class_243 entityPos = entity2.method_19538();
                double distSq = entityPos.method_1025(center);
                double dist = Math.sqrt(distSq);
                boolean blocked = ExplosionManager.isExplosionBlocked(world, center, entity2.method_33571(), maxHardness, Math.round(finalRadius));
                class_1282 damageSource = owner != null ? owner.method_48923().method_48819(explodingEntity, (class_1297)owner) : entity2.method_48923().method_48819(null, null);
                if (!blocked) {
                    float damage = (float)class_3532.method_16436((double)(dist / (double)finalRadius), (double)finalCenterDmg, (double)finalRimDmg);
                    entity2.method_5643(damageSource, damage);
                    continue;
                }
                entity2.method_5643(damageSource, finalRimDmg * 0.2f);
            }
        }
    }

    public static void explode(class_1937 world, class_2338 pos, float explosionRadius, float centerDamage, float rimDamage, boolean dontBreak, QueuedExplosionSound sound, class_1309 owner) {
        boolean harmless = false;
        float maxHardness = 6.0f;
        List<Object> explosionBlocks = !dontBreak ? ExplosionManager.getExplosionBlocks(world, pos, Math.round(explosionRadius), maxHardness) : new ArrayList();
        if (sound != null) {
            world.method_8396(null, pos, sound.soundEvent, sound.category, sound.volume, sound.pitch);
        }
        if (world.method_8503() == null) {
            return;
        }
        world.method_8503().execute(() -> {
            HashMap<class_2248, Integer> blockBreakCount = new HashMap<class_2248, Integer>();
            int dropThreshold = 32;
            for (class_2338 pos1 : explosionBlocks) {
                if (world.method_8320(pos1).method_26204() instanceof class_2530) {
                    class_1541 tntEntity = new class_1541(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, null);
                    tntEntity.method_6967(5);
                    world.method_8649((class_1297)tntEntity);
                } else {
                    class_2680 state = world.method_8320(pos1);
                    class_2586 be = world.method_8321(pos1);
                    if (world.method_8409().method_43057() < 0.3f) {
                        boolean shouldDrop;
                        int count = blockBreakCount.getOrDefault(state.method_26204(), 0);
                        blockBreakCount.put(state.method_26204(), count + 1);
                        boolean bl = shouldDrop = count < dropThreshold;
                        if (shouldDrop) {
                            class_2248.method_9610((class_2680)state, (class_1936)world, (class_2338)pos1, (class_2586)be);
                        }
                    }
                }
                world.method_8652(pos1, class_2246.field_10124.method_9564(), 7);
            }
        });
        class_243 center = class_243.method_24953((class_2382)pos);
        List nearbyEntities = world.method_8390(class_1309.class, new class_238(center.field_1352 - (double)explosionRadius, center.field_1351 - (double)explosionRadius, center.field_1350 - (double)explosionRadius, center.field_1352 + (double)explosionRadius, center.field_1351 + (double)explosionRadius, center.field_1350 + (double)explosionRadius), entity -> entity.method_5805() && !entity.method_7325());
        if (!harmless) {
            for (class_1297 entity2 : nearbyEntities) {
                if (entity2.equals((Object)owner)) continue;
                class_243 entityPos = entity2.method_19538();
                double distSq = entityPos.method_1025(center);
                double dist = Math.sqrt(distSq);
                boolean blocked = ExplosionManager.isExplosionBlocked(world, center, entity2.method_33571(), maxHardness, Math.round(explosionRadius));
                class_1282 damageSource = world.method_48963().method_48819(null, (class_1297)owner);
                if (!blocked) {
                    float damage = (float)class_3532.method_16436((double)(dist / (double)explosionRadius), (double)centerDamage, (double)rimDamage);
                    entity2.method_5643(damageSource, damage);
                    continue;
                }
                entity2.method_5643(damageSource, rimDamage * 0.2f);
            }
        }
    }

    public static int getItemEntityCount(class_3218 world) {
        return world.method_18198((class_5575)class_1299.field_6052, entity -> true).size();
    }

    private static boolean isExplosionBlocked(class_1937 world, class_243 from, class_243 to, float maxHardness, int maxSteps) {
        class_243 direction = to.method_1020(from).method_1029();
        double totalDistance = from.method_1022(to);
        double stepSize = totalDistance / (double)maxSteps;
        for (int i = 1; i <= maxSteps; ++i) {
            class_243 stepPos = from.method_1019(direction.method_1021(stepSize * (double)i));
            class_2338 blockPos = class_2338.method_49638((class_2374)stepPos);
            class_2680 state = world.method_8320(blockPos);
            if (state.method_26215() || !(state.method_26204().method_36555() > maxHardness)) continue;
            return true;
        }
        return false;
    }

    public static boolean isObstructed(class_2338 start, class_2338 end, List<class_2338> obstructingBlocks) {
        class_243 s = new class_243((double)start.method_10263() + 0.5, (double)start.method_10264() + 0.5, (double)start.method_10260() + 0.5);
        class_243 e = new class_243((double)end.method_10263() + 0.5, (double)end.method_10264() + 0.5, (double)end.method_10260() + 0.5);
        class_243 dir = e.method_1020(s).method_1029();
        double maxDist = s.method_1022(e);
        double step = 1.0;
        int steps = (int)(maxDist / step);
        for (int i = 0; i <= steps; ++i) {
            class_243 current = s.method_1019(dir.method_1021((double)i * step));
            class_2338 currentPos = new class_2338((int)current.method_10216(), (int)current.method_10214(), (int)current.method_10215());
            if (!obstructingBlocks.contains(currentPos)) continue;
            return true;
        }
        return false;
    }

    public static List<class_2338> getExplosionBlocks(class_1937 world, class_2338 center, int radius, float maxHardness) {
        int z;
        int y;
        int x;
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        ArrayList<class_2338> obstructingBlocks = new ArrayList<class_2338>();
        for (x = -radius; x <= radius; ++x) {
            for (y = -radius; y <= radius; ++y) {
                for (z = -radius; z <= radius; ++z) {
                    float hardness = world.method_8320(center.method_10069(x, y, z)).method_26204().method_36555();
                    if (x * x + y * y + z * z > radius * radius || !(hardness > maxHardness) && !(hardness < 0.0f)) continue;
                    obstructingBlocks.add(center.method_10069(x, y, z));
                }
            }
        }
        for (x = -radius; x <= radius; ++x) {
            for (y = -radius; y <= radius; ++y) {
                for (z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > radius * radius) continue;
                    class_2338 blockPos = center.method_10069(x, y, z);
                    float hardness = world.method_8320(center.method_10069(x, y, z)).method_26204().method_36555();
                    if (!(hardness <= maxHardness) || !(hardness >= 0.0f) || ExplosionManager.isObstructed(center, blockPos, obstructingBlocks)) continue;
                    result.add(blockPos);
                }
            }
        }
        return result;
    }
}

