/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.helpers;

import java.util.ArrayList;
import java.util.List;
import magnusmakesgames.wizardry.items.custom.SpellInfo;
import magnusmakesgames.wizardry.items.custom.SpellType;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import magnusmakesgames.wizardry.items.custom.wand.WandItem;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5819;
import org.joml.Math;

public class WandSelector {
    public static List<WandItem> allWands = new ArrayList<WandItem>();
    public static List<SpellItem> allSpells = new ArrayList<SpellItem>();
    public static List<SpellItem> endOnlySpells = new ArrayList<SpellItem>();

    public static class_1799 SelectWand(int minLevel, int maxLevel) {
        int randomIndex = class_5819.method_43047().method_43048(maxLevel - minLevel) + minLevel;
        randomIndex = Math.clamp((int)0, (int)allWands.size(), (int)randomIndex);
        WandItem selectedWand = allWands.get(randomIndex);
        return selectedWand.method_7854();
    }

    public static List<SpellInfo> SelectSpells(int minAmount, int maxAmount, int minWeight, int maxWeight, boolean isEnd) {
        class_5819 random = class_5819.method_43047();
        ArrayList<SpellInfo> selectedSpells = new ArrayList<SpellInfo>();
        int spellCount = random.method_43048(maxAmount - minAmount) + minAmount + 1;
        ArrayList<SpellInfo> availableSpells = new ArrayList<SpellInfo>();
        for (SpellItem spellItem : allSpells) {
            if (spellItem.getSpellInfo().weight < java.lang.Math.min(minWeight, 1)) continue;
            availableSpells.add(spellItem.getSpellInfo());
        }
        if (isEnd) {
            for (SpellItem spellItem : endOnlySpells) {
                if (spellItem.getSpellInfo().weight < java.lang.Math.min(minWeight, 1)) continue;
                availableSpells.add(spellItem.getSpellInfo());
            }
        }
        for (int i = 0; i < spellCount - 1 && !availableSpells.isEmpty(); ++i) {
            SpellInfo selectedSpell = WandSelector.selectRandomSpellByWeight(availableSpells, random);
            selectedSpells.add(selectedSpell);
        }
        SpellInfo projectileSpell = WandSelector.selectRandomProjectileSpell(availableSpells, random);
        selectedSpells.add(projectileSpell);
        return selectedSpells;
    }

    private static SpellInfo selectRandomSpellByWeight(List<SpellInfo> availableSpells, class_5819 random) {
        int totalWeight = 0;
        for (SpellInfo spell : availableSpells) {
            totalWeight += spell.weight;
        }
        int randomWeight = random.method_43048(totalWeight);
        int cumulativeWeight = 0;
        for (SpellInfo spell : availableSpells) {
            if (randomWeight >= (cumulativeWeight += spell.weight)) continue;
            return spell;
        }
        return availableSpells.get(availableSpells.size() - 1);
    }

    private static SpellInfo selectRandomProjectileSpell(List<SpellInfo> availableSpells, class_5819 random) {
        ArrayList<SpellInfo> projectileSpells = new ArrayList<SpellInfo>();
        for (SpellInfo spell : availableSpells) {
            if (spell.spellType != SpellType.Projectile) continue;
            projectileSpells.add(spell);
        }
        if (projectileSpells.isEmpty()) {
            throw new IllegalStateException("No projectile spells available for final selection.");
        }
        return WandSelector.selectRandomSpellByWeight(projectileSpells, random);
    }

    public static class_1799 createRandomWand(int minWandLevel, int maxWandLevel, int minSpells, int maxSpells, int minSpellWeight, int maxSpellWeight, boolean isEnd) {
        class_1799 wand = WandSelector.SelectWand(minWandLevel, maxWandLevel);
        class_2487 wandNbt = new class_2487();
        WandItem wandItem = (WandItem)wand.method_7909();
        int maxSlots = java.lang.Math.min(maxSpells, wandItem.wandInfo.maxSlots);
        int minSlots = java.lang.Math.min(minSpells, wandItem.wandInfo.maxSlots) - 1;
        List<SpellInfo> spells = WandSelector.SelectSpells(minSlots, maxSlots, minSpellWeight, maxSpellWeight, isEnd);
        class_2499 spellList = new class_2499();
        for (SpellInfo spell : spells) {
            class_2487 spellNbt = new class_2487();
            spellNbt.method_10582("id", spell.id);
            spellNbt.method_10569("remainingCasts", spell.maxCasts);
            spellList.add((Object)spellNbt);
        }
        wandNbt.method_10566("Spells", (class_2520)spellList);
        wandNbt.method_10569("current_spell_index", 0);
        wandNbt.method_10569("first_spell_index", 0);
        wandNbt.method_10569("last_spell_index", spells.size() - 1);
        wand.method_7980(wandNbt);
        return wand;
    }
}

