/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.items.custom.spells.items.projectile;

import java.util.List;
import magnusmakesgames.wizardry.entities.spells.MagicProjectileEntity;
import magnusmakesgames.wizardry.helpers.ProjectileSpellHelper;
import magnusmakesgames.wizardry.items.custom.SpellInfo;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import magnusmakesgames.wizardry.sounds.WizardrySounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class PollenSpell
extends SpellItem {
    public PollenSpell(class_1792.class_1793 settings, SpellInfo spellInfo) {
        super(settings, spellInfo);
    }

    @Override
    public String[] GetAdditionalTooltips() {
        return new String[]{"Damage: 3"};
    }

    @Override
    public void Cast(class_1937 world, class_1309 caster, class_5819 random, MinecraftServer server, class_243 castPos, float castPitch, float castYaw, float spread, List<SpellItem> modifiers) {
        float speed = ProjectileSpellHelper.getProjectileSpeed(0.75f, modifiers);
        int lifetime = ProjectileSpellHelper.getProjectileLifetime(300, modifiers);
        world.method_8396(null, class_2338.method_49638((class_2374)castPos), WizardrySounds.CAST_PROJECTILE, class_3419.field_15248, 0.25f, ProjectileSpellHelper.getPitch(1.0f, 0.1f, class_5819.method_43047()));
        MagicProjectileEntity projectile = new MagicProjectileEntity(caster, world, castPos, lifetime);
        ProjectileSpellHelper.setVelocity(projectile, castPitch += random.method_43057() * spread - spread / 2.0f, castYaw += random.method_43057() * spread - spread / 2.0f, 0.0f, speed, 0.0f);
        projectile.method_7432((class_1297)caster);
        projectile.method_16940(new class_1799((class_1935)class_2246.field_10124, 1));
        projectile.setParticleCommand("minecraft:dust 0.7 0.75 0.8 1.15");
        projectile.setHitDamage(3);
        projectile.setDrag(0.7f);
        projectile.setGravity(0.012f);
        projectile.setModifiers(modifiers);
        projectile.setDuplicate(false);
        projectile.setSpellItem(this);
        projectile.setCanSelfDamage(true);
        world.method_8649((class_1297)projectile);
    }

    @Override
    public void Tick(class_1937 world, class_1297 entity, class_1309 caster, class_5819 random, MinecraftServer server, List<SpellItem> modifiers) {
        entity.method_45319(this.getHomingVelocity(world, entity.method_19538()));
        entity.field_6037 = true;
    }

    private class_243 getHomingVelocity(class_1937 world, class_243 thisPos) {
        float homingRadius = 7.0f;
        float homingStrength = 0.03f;
        List nearbyEntities = world.method_8390(class_1309.class, new class_238(thisPos.field_1352 - (double)homingRadius, thisPos.field_1351 - (double)homingRadius, thisPos.field_1350 - (double)homingRadius, thisPos.field_1352 + (double)homingRadius, thisPos.field_1351 + (double)homingRadius, thisPos.field_1350 + (double)homingRadius), entity -> entity.method_5805() && !entity.method_7325() && entity instanceof class_1569);
        if (!nearbyEntities.isEmpty()) {
            class_1297 closestEntity = null;
            double closestDistanceSq = Double.MAX_VALUE;
            for (class_1297 entity2 : nearbyEntities) {
                double distanceSq = entity2.method_33571().method_1025(thisPos);
                if (!(distanceSq < closestDistanceSq)) continue;
                closestDistanceSq = distanceSq;
                closestEntity = entity2;
            }
            if (closestEntity != null) {
                class_243 diff = closestEntity.method_33571().method_1020(thisPos).method_1029();
                return diff.method_1021((double)homingStrength);
            }
        }
        return class_243.field_1353;
    }

    @Override
    public void CastDuplicate(class_1937 world, class_1297 entity, class_1309 caster, class_5819 random, MinecraftServer server, class_243 castPos, float castPitch, float castYaw, float spread, List<SpellItem> modifiers) {
        float speed = ProjectileSpellHelper.getProjectileSpeed(0.75f, modifiers);
        int lifetime = ProjectileSpellHelper.getProjectileLifetime(300, modifiers);
        world.method_8396(null, class_2338.method_49638((class_2374)castPos), WizardrySounds.CAST_PROJECTILE, class_3419.field_15248, 0.12f, ProjectileSpellHelper.getPitch(1.0f, 0.1f, class_5819.method_43047()));
        MagicProjectileEntity projectile = new MagicProjectileEntity(caster, world, castPos, lifetime);
        ProjectileSpellHelper.setVelocity(projectile, castPitch += random.method_43057() * spread - spread / 2.0f, castYaw += random.method_43057() * spread - spread / 2.0f, 0.0f, speed, 0.0f);
        projectile.method_7432((class_1297)caster);
        projectile.method_16940(new class_1799((class_1935)class_2246.field_10124, 1));
        projectile.setParticleCommand("minecraft:dust 0.7 0.75 0.8 1.15");
        projectile.setHitDamage(3);
        projectile.setDrag(0.7f);
        projectile.setGravity(0.012f);
        projectile.setModifiers(modifiers);
        projectile.setDuplicate(true);
        projectile.setSpellItem(this);
        projectile.setCanSelfDamage(true);
        world.method_8649((class_1297)projectile);
    }
}

