/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.items.custom.spells.items.projectile;

import java.util.List;
import magnusmakesgames.wizardry.entities.spells.MagicProjectileEntity;
import magnusmakesgames.wizardry.helpers.CustomFunctions;
import magnusmakesgames.wizardry.helpers.ExplosionManager;
import magnusmakesgames.wizardry.helpers.ProjectileSpellHelper;
import magnusmakesgames.wizardry.helpers.QueuedExplosionSound;
import magnusmakesgames.wizardry.items.custom.SpellInfo;
import magnusmakesgames.wizardry.items.custom.spells.SpellItem;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class SonicShriekSpell
extends SpellItem {
    public SonicShriekSpell(class_1792.class_1793 settings, SpellInfo spellInfo) {
        super(settings, spellInfo);
    }

    @Override
    public String[] GetAdditionalTooltips() {
        return new String[]{"Dmg. Explosion: 8", "Explosion Radius: 2", "Always drops from wardens"};
    }

    @Override
    public void Cast(class_1937 world, class_1309 caster, class_5819 random, MinecraftServer server, class_243 castPos, float castPitch, float castYaw, float spread, List<SpellItem> modifiers) {
        float speed = ProjectileSpellHelper.getProjectileSpeed(3.0f, modifiers);
        int lifetime = ProjectileSpellHelper.getProjectileLifetime(8, modifiers);
        world.method_8396(null, class_2338.method_49638((class_2374)castPos), class_3417.field_38831, class_3419.field_15248, 1.0f, ProjectileSpellHelper.getPitch(1.0f, 0.05f, class_5819.method_43047()));
        MagicProjectileEntity projectile = new MagicProjectileEntity(caster, world, castPos, lifetime);
        ProjectileSpellHelper.setVelocity(projectile, castPitch += random.method_43057() * spread - spread / 2.0f, castYaw += random.method_43057() * spread - spread / 2.0f, 0.0f, speed, 0.0f);
        projectile.method_7432((class_1297)caster);
        projectile.method_16940(new class_1799((class_1935)class_1802.field_8162, 1));
        projectile.setParticleCommand("minecraft:sonic_boom");
        projectile.setHitDamage(0);
        projectile.setModifiers(modifiers);
        projectile.setDuplicate(false);
        projectile.setGravity(0.01f);
        projectile.setSpellItem(this);
        projectile.setDrag(1.0f);
        world.method_8649((class_1297)projectile);
    }

    @Override
    public void Tick(class_1937 world, class_1297 entity, class_1309 caster, class_5819 random, MinecraftServer server, List<SpellItem> modifiers) {
        if (entity.field_6012 % 2 == 0) {
            QueuedExplosionSound sound = new QueuedExplosionSound(class_3417.field_38830, class_3419.field_15248, 0.5f, ProjectileSpellHelper.getPitch(1.0f, 0.05f, class_5819.method_43047()));
            float modifierDamage = CustomFunctions.getFinalDamage(0.0f, modifiers);
            ExplosionManager.QueueExplosion(world, 10, entity.method_24515(), 2, 8.0f + modifierDamage / 1.5f, 7.0f + modifierDamage / 2.0f, true, sound, caster);
        }
    }

    @Override
    public boolean OnHitEntity(class_1937 world, class_1297 entity, class_1309 caster, class_1309 hitEntity, class_5819 random, MinecraftServer server, List<SpellItem> modifiers) {
        return false;
    }

    @Override
    public void CastDuplicate(class_1937 world, class_1297 entity, class_1309 caster, class_5819 random, MinecraftServer server, class_243 castPos, float castPitch, float castYaw, float spread, List<SpellItem> modifiers) {
        MagicProjectileEntity projectile = ProjectileSpellHelper.CastProjectileDuplicate(world, caster, server, class_1802.field_8162, this, 0, "minecraft:sonic_boom", castPos, castPitch, castYaw, 40, modifiers, false);
        projectile.setGravity(0.02f);
    }
}

