/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.wizardry.screen;

import java.util.Set;
import magnusmakesgames.wizardry.blocks.entity.WandbuildingTableBlockEntity;
import magnusmakesgames.wizardry.helpers.ItemGiver;
import magnusmakesgames.wizardry.items.custom.slots.SpellSlot;
import magnusmakesgames.wizardry.items.custom.slots.WandSlot;
import magnusmakesgames.wizardry.items.custom.wand.WandItem;
import magnusmakesgames.wizardry.screen.WizardryScreenHandlers;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class WandbuildingTableScreenHandler
extends class_1703 {
    private final class_1263 inventory;
    public final WandbuildingTableBlockEntity blockEntity;

    public WandbuildingTableScreenHandler(int syncId, class_1661 inventory1, class_2540 buf) {
        this(syncId, inventory1, inventory1.field_7546.method_37908().method_8321(buf.method_10811()));
    }

    public WandbuildingTableScreenHandler(int syncId, class_1661 playerInventory, class_2586 blockEntity) {
        super(WizardryScreenHandlers.WANDBUILDING_TABLE_SCREEN_HANDLER, syncId);
        class_1657 class_16572;
        if (!(blockEntity instanceof WandbuildingTableBlockEntity)) {
            throw new IllegalStateException("Expected WandbuildingTableBlockEntity but got " + String.valueOf(blockEntity));
        }
        WandbuildingTableBlockEntity wandTable = (WandbuildingTableBlockEntity)blockEntity;
        this.inventory = (class_1263)blockEntity;
        this.blockEntity = wandTable;
        this.inventory.method_5435(playerInventory.field_7546);
        int slotCount = this.blockEntity.getSlotCount();
        WandbuildingTableScreenHandler.method_17359((class_1263)this.blockEntity, (int)slotCount);
        if (!playerInventory.field_7546.method_37908().method_8608() && (class_16572 = playerInventory.field_7546) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            this.blockEntity.addViewer(serverPlayer);
        }
        this.method_7621(new WandSlot(this.inventory, 0, 26, 39));
        if (slotCount > 1) {
            this.AddSpellSlots(wandTable.getSlotCount() - 1);
        }
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    private void AddSpellSlots(int count) {
        int columnCount = 6;
        int startY = 39 - (int)Math.floor((float)(count - 1) / (float)columnCount) * 9;
        for (int i = 0; i < count; ++i) {
            this.method_7621(new SpellSlot(this.inventory, i + 1, 62 + i % columnCount * 18, startY + (int)(Math.floor((float)i / (float)columnCount) * 18.0)));
        }
    }

    public void updateSpellSlots(int newSlotCount) {
        this.field_7761.removeIf(slot -> slot.field_7871 == this.inventory && slot.method_34266() != 0);
        WandbuildingTableScreenHandler.method_17359((class_1263)this.blockEntity, (int)newSlotCount);
        if (newSlotCount > 1) {
            this.AddSpellSlots(newSlotCount - 1);
        }
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.inventory.method_5439() ? !this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size(), true) : !this.method_7616(originalStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        this.blockEntity.onSlotChanged(invSlot, class_1799.field_8037);
        return newStack;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (slotIndex == 0 && actionType == class_1713.field_7790 && this.blockEntity.method_5438(0).method_7909() instanceof WandItem) {
            if (!player.method_37908().method_8608()) {
                ((class_3222)player).method_7346();
                ItemGiver.TryGiveItemStack((class_3222)player, this.blockEntity.method_5438(0));
                this.blockEntity.method_5447(0, class_1799.field_8037);
                this.blockEntity.setSlotCount(1);
            }
            player.method_31548().method_5431();
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (!player.method_37908().method_8608() && player instanceof class_3222) {
            Set<class_3222> viewers;
            class_3222 serverPlayer = (class_3222)player;
            if (this.blockEntity == null) {
                return;
            }
            if (!this.blockEntity.isUpdatingScreen(serverPlayer) && (viewers = this.blockEntity.getViewers()).size() == 1) {
                for (class_3222 viewer : viewers) {
                    ItemGiver.TryGiveItemStack(viewer, this.blockEntity.method_5438(0));
                    this.blockEntity.setSlotCount(1);
                    this.blockEntity.setCloseTable(viewer);
                    viewer.method_31548().method_5431();
                }
                this.blockEntity.method_5447(0, class_1799.field_8037);
                this.blockEntity.method_5431();
                this.updateSpellSlots(1);
            }
            this.blockEntity.removeUpdatingPlayer(serverPlayer);
            this.blockEntity.removeViewer(serverPlayer);
        }
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new class_1735((class_1263)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

