/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed;

import com.mojang.authlib.GameProfile;
import dev.tocraft.craftedcore.config.Config;
import dev.tocraft.craftedcore.config.ConfigLoader;
import dev.tocraft.craftedcore.event.common.CommandEvents;
import dev.tocraft.craftedcore.event.common.EntityEvents;
import dev.tocraft.craftedcore.event.common.PlayerEvents;
import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.craftedcore.platform.PlatformData;
import dev.tocraft.craftedcore.platform.VersionChecker;
import dev.tocraft.remorphed.RemorphedClient;
import dev.tocraft.remorphed.command.RemorphedCommand;
import dev.tocraft.remorphed.config.RemorphedConfig;
import dev.tocraft.remorphed.handler.LivingDeathHandler;
import dev.tocraft.remorphed.handler.PlayerRespawnHandler;
import dev.tocraft.remorphed.handler.SwapShapeCallback;
import dev.tocraft.remorphed.handler.UnlockShapeCallback;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.network.NetworkHandler;
import dev.tocraft.remorphed.permission.PermissionManager;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.events.ShapeEvents;
import dev.tocraft.walkers.api.platform.ApiLevel;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Remorphed {
    @ApiStatus.Internal
    public static final Logger LOGGER = LoggerFactory.getLogger(Remorphed.class);
    public static final String MODID = "remorphed";
    public static final RemorphedConfig CONFIG = (RemorphedConfig)ConfigLoader.register((String)"remorphed", (Config[])new RemorphedConfig[0]);
    public static boolean displayDataInMenu = Remorphed.CONFIG.show_traits_by_default;
    @ApiStatus.Internal
    public static final boolean foundSkinShifter = PlatformData.isModLoaded((String)"skinshifter");

    public void initialize() {
        ShapeEvents.UNLOCK_SHAPE.register((Object)new UnlockShapeCallback());
        ShapeEvents.SWAP_SHAPE.register((Object)new SwapShapeCallback());
        if (!Remorphed.CONFIG.unlockFriendlyNormal) {
            ApiLevel.setApiLevel((ApiLevel)ApiLevel.MORPHING_AND_VARIANTS_MENU_ONLY);
        }
        Walkers.devs.add(UUID.fromString("74b6d9b3-c8c1-40db-ab82-ccc290d1aa03"));
        Walkers.devs.add(UUID.fromString("d014c6c7-1c15-46b7-94e1-a5dd28f9425e"));
        VersionChecker.registerModrinthChecker((String)MODID, (String)MODID, (Component)Component.literal((String)"Remorphed"));
        if (PlatformData.getEnv() == Dist.CLIENT) {
            new RemorphedClient().initialize();
        }
        NetworkHandler.registerPacketReceiver();
        CommandEvents.REGISTRATION.register((Object)new RemorphedCommand());
        EntityEvents.LIVING_DEATH.register((Object)new LivingDeathHandler());
        PlayerEvents.PLAYER_RESPAWN.register((Object)new PlayerRespawnHandler());
        Walkers.CONFIG.unlockOverridesCurrentShape = Remorphed.CONFIG.unlockFriendlyNormal;
        Walkers.CONFIG.save();
        PlayerEvents.PLAYER_JOIN.register(NetworkHandler::sendFavoriteSync);
    }

    public static boolean canUseEveryShape(@NotNull Player player) {
        return player.isCreative() && Remorphed.CONFIG.creativeUnlockAll;
    }

    public static boolean canUseShape(Player player, ShapeType<?> type) {
        if (Remorphed.CONFIG.usePermissions && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!PermissionManager.canMorph(serverPlayer)) {
                return false;
            }
            if (type != null && !PermissionManager.canMorphIntoType(serverPlayer, type.getEntityType())) {
                return false;
            }
            if (Remorphed.CONFIG.lockTransform && !PermissionManager.canBypassTransformLock(serverPlayer)) {
                return false;
            }
            if (Remorphed.canUseEveryShape(player)) {
                return true;
            }
            return !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(player, type.getEntityType()) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(player, type.getEntityType()));
        }
        return Remorphed.canUseEveryShape(player) || !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(player, type.getEntityType()) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(player, type.getEntityType()));
    }

    public static boolean canUseShape(Player player, EntityType<?> type) {
        if (Remorphed.CONFIG.usePermissions && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!PermissionManager.canMorph(serverPlayer)) {
                return false;
            }
            if (type != null && !PermissionManager.canMorphIntoType(serverPlayer, type)) {
                return false;
            }
            if (Remorphed.CONFIG.lockTransform && !PermissionManager.canBypassTransformLock(serverPlayer)) {
                return false;
            }
            if (Remorphed.canUseEveryShape(player)) {
                return true;
            }
            return !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(player, type) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(player, type));
        }
        return Remorphed.canUseEveryShape(player) || !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(player, type) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(player, type));
    }

    public static List<ShapeType<?>> getUnlockedShapes(Player player) {
        ArrayList unlocked = new ArrayList();
        for (ShapeType shapeType : ShapeType.getAllTypes((Level)player.level())) {
            if (unlocked.contains(shapeType) || !Remorphed.canUseShape(player, shapeType)) continue;
            unlocked.add(shapeType);
        }
        return unlocked;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static List<GameProfile> getUnlockedSkins(Player player) {
        int killRequirement = Remorphed.getPlayerKillRequirement(player);
        return new ArrayList<GameProfile>(PlayerMorph.getUnlockedSkinIds(player).keySet().stream().filter(skinId -> (PlayerMorph.getPlayerKills(player, skinId) >= killRequirement || killRequirement == 0) && killRequirement != -1).map(id -> SkinPlayerData.getSkinProfile((UUID)id).getNow(Optional.empty()).orElse(null)).filter(Objects::nonNull).toList());
    }

    public static int getKillToUnlock(EntityType<?> type) {
        return Remorphed.CONFIG.killToUnlockByType.getOrDefault(EntityType.getKey(type).toString(), Remorphed.CONFIG.killToUnlock);
    }

    public static int getKillToUnlock(Player player, EntityType<?> type) {
        return Remorphed.getKillToUnlock(type);
    }

    public static int getKillValue(EntityType<?> type) {
        return Remorphed.CONFIG.killValueByType.getOrDefault(EntityType.getKey(type).toString(), Remorphed.CONFIG.killValue);
    }

    public static int getKillValue(Player player, EntityType<?> type) {
        return Remorphed.getKillValue(type);
    }

    public static int getPlayerKillRequirement(Player player) {
        return Remorphed.CONFIG.killToUnlockPlayers;
    }

    public static int getPlayerKillValue(Player player) {
        return Remorphed.CONFIG.playerKillValue;
    }

    public static void sync(ServerPlayer player) {
        Remorphed.sync(player, player);
    }

    public static void sync(ServerPlayer changed, ServerPlayer packetTarget) {
        CompoundTag compoundTag = new CompoundTag();
        Map<ShapeType<? extends LivingEntity>, Integer> unlockedShapes = PlayerMorph.getUnlockedShapes((Player)changed);
        ListTag shapesList = new ListTag();
        unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                CompoundTag compound = new CompoundTag();
                compound.putString("id", EntityType.getKey((EntityType)shape.getEntityType()).toString());
                compound.putInt("variant", shape.getVariantData());
                compound.putInt("killAmount", killAmount.intValue());
                shapesList.add((Object)compound);
            }
        });
        if (!shapesList.isEmpty()) {
            compoundTag.put("UnlockedShapes", (Tag)shapesList);
        }
        Map<UUID, Integer> unlockedSkins = PlayerMorph.getUnlockedSkinIds((Player)changed);
        ListTag skinsList = new ListTag();
        unlockedSkins.forEach((skinId, killAmount) -> {
            if (killAmount > 0 && skinId != null) {
                CompoundTag compound = new CompoundTag();
                compound.putIntArray("uuid", UUIDUtil.uuidToIntArray((UUID)skinId));
                compound.putInt("killAmount", killAmount.intValue());
                skinsList.add((Object)compound);
            }
        });
        if (!skinsList.isEmpty()) {
            compoundTag.put("UnlockedSkins", (Tag)skinsList);
        }
        ListTag morphCounter = new ListTag();
        PlayerMorph.getShapeCounter((Player)changed).forEach((type, count) -> {
            if (count > 0 && type != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putBoolean("isSkin", false);
                entryTag.putString("id", EntityType.getKey((EntityType)type.getEntityType()).toString());
                entryTag.putInt("variant", type.getVariantData());
                entryTag.putInt("counter", count.intValue());
                morphCounter.add((Object)entryTag);
            }
        });
        PlayerMorph.getSkinCounter((Player)changed).forEach((skinId, count) -> {
            if (count > 0 && skinId != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putBoolean("isSkin", true);
                entryTag.putIntArray("uuid", UUIDUtil.uuidToIntArray((UUID)skinId));
                entryTag.putInt("counter", count.intValue());
                morphCounter.add((Object)entryTag);
            }
        });
        if (!morphCounter.isEmpty()) {
            compoundTag.put("MorphCounter", (Tag)morphCounter);
        }
        compoundTag.putIntArray("uuid", UUIDUtil.uuidToIntArray((UUID)changed.getUUID()));
        ModernNetworking.sendToPlayer((ServerPlayer)packetTarget, (ResourceLocation)NetworkHandler.UNLOCKED_SYNC, (CompoundTag)compoundTag);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
    }
}

