/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.handler;

import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.permission.PermissionManager;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.events.ShapeEvents;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class UnlockShapeCallback
implements ShapeEvents.UnlockShapeCallback {
    public InteractionResult unlock(ServerPlayer player, ShapeType<?> type) {
        if (type != null) {
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canMorphIntoType(player, type.getEntityType())) {
                return InteractionResult.FAIL;
            }
            if (!Remorphed.CONFIG.lockTransform && Remorphed.CONFIG.unlockFriendlyNormal) {
                LivingEntity entityToBeUnlocked = type.create((Level)player.level(), (Player)player);
                if (!(entityToBeUnlocked instanceof Enemy)) {
                    PlayerMorph.getUnlockedShapes((Player)player).put(type, Remorphed.getKillToUnlock(type.getEntityType()));
                }
            } else if (!(Remorphed.canUseShape((Player)player, type) || type.getEntityType().equals(EntityType.WOLF) && Walkers.hasSpecialShape((UUID)player.getUUID()))) {
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }
}

