/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.mixin;

import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements RemorphedPlayerDataProvider {
    @Unique
    private final Map<ShapeType<? extends LivingEntity>, Integer> remorphed$unlockedShapes = new HashMap<ShapeType<? extends LivingEntity>, Integer>();
    @Unique
    private final Set<ShapeType<?>> remorphed$favoriteShapes = new HashSet();
    @Unique
    private final Map<UUID, Integer> remorphed$unlockedSkins = new ConcurrentHashMap<UUID, Integer>();
    @Unique
    private final Set<UUID> remorphed$favoriteSkins = new CopyOnWriteArraySet<UUID>();
    @Unique
    private final Map<ShapeType<?>, Integer> remorphed$ShapeMorphCounter = new ConcurrentHashMap();
    @Unique
    private final Map<UUID, Integer> remorphed$SkinMorphCounter = new ConcurrentHashMap<UUID, Integer>();
    @Unique
    private static final String UNLOCKED_SHAPES = "UnlockedShapes";
    @Unique
    private static final String FAVORITE_SHAPES = "FavoriteShapes";
    @Unique
    private static final String UNLOCKED_SKINS = "UnlockedSkins";
    @Unique
    private static final String FAVORITE_SKINS = "FavoriteSkins";
    @Unique
    private static final String MORPH_COUNTER = "MorphCounter";

    @Shadow
    public abstract boolean isCreative();

    private PlayerEntityMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void serverTick(CallbackInfo info) {
        if (!this.level().isClientSide) {
            Remorphed.sync((ServerPlayer)this);
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="RETURN")})
    private void readNbt(ValueInput in, CallbackInfo ci) {
        this.remorphed$readData(in.read("remorphed", CompoundTag.CODEC).orElse(new CompoundTag()));
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="RETURN")})
    private void writeNbt(ValueOutput out, CallbackInfo ci) {
        out.store("remorphed", CompoundTag.CODEC, (Object)this.remorphed$writeData());
    }

    @Unique
    @NotNull
    private CompoundTag remorphed$writeData() {
        CompoundTag tag = new CompoundTag();
        ListTag unlockedShapes = new ListTag();
        this.remorphed$unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putString("id", EntityType.getKey((EntityType)shape.getEntityType()).toString());
                entryTag.putInt("variant", shape.getVariantData());
                entryTag.putInt("killAmount", killAmount.intValue());
                unlockedShapes.add((Object)entryTag);
            }
        });
        if (!unlockedShapes.isEmpty()) {
            tag.put(UNLOCKED_SHAPES, (Tag)unlockedShapes);
        }
        ListTag favoriteShapes = new ListTag();
        this.remorphed$favoriteShapes.forEach(shape -> {
            if (shape != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putString("id", EntityType.getKey((EntityType)shape.getEntityType()).toString());
                entryTag.putInt("variant", shape.getVariantData());
                favoriteShapes.add((Object)entryTag);
            }
        });
        if (!favoriteShapes.isEmpty()) {
            tag.put(FAVORITE_SHAPES, (Tag)favoriteShapes);
        }
        ListTag unlockedSkins = new ListTag();
        this.remorphed$unlockedSkins.forEach((skinId, killAmount) -> {
            if (killAmount > 0 && skinId != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putIntArray("uuid", UUIDUtil.uuidToIntArray((UUID)skinId));
                entryTag.putInt("killAmount", killAmount.intValue());
                unlockedSkins.add((Object)entryTag);
            }
        });
        if (!unlockedSkins.isEmpty()) {
            tag.put(UNLOCKED_SKINS, (Tag)unlockedSkins);
        }
        ListTag favoriteSkins = new ListTag();
        this.remorphed$favoriteSkins.forEach(skinId -> {
            if (skinId != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putIntArray("uuid", UUIDUtil.uuidToIntArray((UUID)skinId));
                favoriteSkins.add((Object)entryTag);
            }
        });
        if (!favoriteSkins.isEmpty()) {
            tag.put(FAVORITE_SKINS, (Tag)favoriteSkins);
        }
        ListTag morphCounter = new ListTag();
        this.remorphed$ShapeMorphCounter.forEach((type, count) -> {
            if (count > 0 && type != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putBoolean("isSkin", false);
                entryTag.putString("id", EntityType.getKey((EntityType)type.getEntityType()).toString());
                entryTag.putInt("variant", type.getVariantData());
                entryTag.putInt("counter", count.intValue());
                morphCounter.add((Object)entryTag);
            }
        });
        this.remorphed$SkinMorphCounter.forEach((skinId, count) -> {
            if (count > 0 && skinId != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putBoolean("isSkin", true);
                entryTag.putIntArray("uuid", UUIDUtil.uuidToIntArray((UUID)skinId));
                entryTag.putInt("counter", count.intValue());
                morphCounter.add((Object)entryTag);
            }
        });
        if (!morphCounter.isEmpty()) {
            tag.put(MORPH_COUNTER, (Tag)morphCounter);
        }
        return tag;
    }

    @Unique
    public void remorphed$readData(@NotNull CompoundTag tag) {
        this.remorphed$unlockedShapes.clear();
        this.remorphed$favoriteShapes.clear();
        this.remorphed$unlockedSkins.clear();
        this.remorphed$favoriteSkins.clear();
        this.remorphed$SkinMorphCounter.clear();
        this.remorphed$ShapeMorphCounter.clear();
        ListTag unlockedShapes = tag.getListOrEmpty(UNLOCKED_SHAPES);
        unlockedShapes.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                ResourceLocation typeId = ResourceLocation.parse((String)((String)((CompoundTag)entry).getString("id").orElseThrow()));
                int typeVariantId = ((CompoundTag)entry).getIntOr("variant", -1);
                int killAmount = ((CompoundTag)entry).getIntOr("killAmount", 0);
                this.remorphed$unlockedShapes.put((ShapeType<? extends LivingEntity>)ShapeType.from((EntityType)BuiltInRegistries.ENTITY_TYPE.get(typeId).map(Holder::value).orElse(null), (int)typeVariantId), killAmount);
            }
        });
        ListTag favoriteShapes = tag.getListOrEmpty(FAVORITE_SHAPES);
        favoriteShapes.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                ResourceLocation typeId = ResourceLocation.parse((String)((String)((CompoundTag)entry).getString("id").orElseThrow()));
                int typeVariantId = ((CompoundTag)entry).getIntOr("variant", -1);
                this.remorphed$favoriteShapes.add(ShapeType.from((EntityType)BuiltInRegistries.ENTITY_TYPE.get(typeId).map(Holder::value).orElse(null), (int)typeVariantId));
            }
        });
        ListTag unlockedSkins = tag.getListOrEmpty(UNLOCKED_SKINS);
        unlockedSkins.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                UUID skinId = UUIDUtil.uuidFromIntArray((int[])((int[])((CompoundTag)entry).getIntArray("uuid").orElseThrow()));
                int killAmount = ((CompoundTag)entry).getIntOr("killAmount", 0);
                this.remorphed$unlockedSkins.put(skinId, killAmount);
            }
        });
        ListTag favoriteSkins = tag.getListOrEmpty(FAVORITE_SKINS);
        favoriteSkins.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                UUID skinId = UUIDUtil.uuidFromIntArray((int[])((int[])((CompoundTag)entry).getIntArray("uuid").orElseThrow()));
                this.remorphed$favoriteSkins.add(skinId);
            }
        });
        ListTag morphCounter = tag.getListOrEmpty(MORPH_COUNTER);
        morphCounter.forEach(entry -> {
            boolean isSkin = (Boolean)((CompoundTag)entry).getBoolean("isSkin").orElseThrow();
            int count = ((CompoundTag)entry).getIntOr("counter", 0);
            if (isSkin) {
                UUID skinId = UUIDUtil.uuidFromIntArray((int[])((int[])((CompoundTag)entry).getIntArray("uuid").orElseThrow()));
                this.remorphed$SkinMorphCounter.put(skinId, count);
            } else {
                ResourceLocation typeId = ResourceLocation.parse((String)((String)((CompoundTag)entry).getString("id").orElseThrow()));
                int typeVariantId = ((CompoundTag)entry).getIntOr("variant", -1);
                this.remorphed$ShapeMorphCounter.put(ShapeType.from((EntityType)BuiltInRegistries.ENTITY_TYPE.get(typeId).map(Holder::value).orElse(null), (int)typeVariantId), count);
            }
        });
    }

    @Override
    @Unique
    public Map<ShapeType<? extends LivingEntity>, Integer> remorphed$getUnlockedShapes() {
        return this.remorphed$unlockedShapes;
    }

    @Override
    @Unique
    public void remorphed$addKill(ShapeType<? extends LivingEntity> type) {
        this.remorphed$unlockedShapes.put(type, this.remorphed$getKills(type) + 1);
    }

    @Override
    @Unique
    public int remorphed$getKills(ShapeType<? extends LivingEntity> type) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            int killAmount = 0;
            for (int i : this.remorphed$unlockedShapes.entrySet().stream().filter(entry -> ((ShapeType)entry.getKey()).getEntityType().equals(type.getEntityType())).map(Map.Entry::getValue).toList()) {
                killAmount += i;
            }
            return killAmount;
        }
        return this.remorphed$unlockedShapes.getOrDefault(type, 0);
    }

    @Override
    @Unique
    public Set<ShapeType<?>> remorphed$getFavoriteShapes() {
        return this.remorphed$favoriteShapes;
    }

    @Override
    @Unique
    public Map<UUID, Integer> remorphed$getUnlockedSkins() {
        return this.remorphed$unlockedSkins;
    }

    @Override
    @Unique
    public void remorphed$addKill(UUID skinId) {
        this.remorphed$unlockedSkins.put(skinId, this.remorphed$getKills(skinId) + 1);
    }

    @Override
    @Unique
    public int remorphed$getKills(UUID skinId) {
        return this.remorphed$unlockedSkins.getOrDefault(skinId, 0);
    }

    @Override
    @Unique
    public Set<UUID> remorphed$getFavoriteSkins() {
        return this.remorphed$favoriteSkins;
    }

    @Override
    @Unique
    public int remorphed$getCounter(ShapeType<? extends LivingEntity> type) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            int counter = 0;
            for (int i : this.remorphed$ShapeMorphCounter.entrySet().stream().filter(entry -> ((ShapeType)entry.getKey()).getEntityType().equals(type.getEntityType())).map(Map.Entry::getValue).toList()) {
                counter += i;
            }
            return counter;
        }
        return this.remorphed$ShapeMorphCounter.getOrDefault(type, 0);
    }

    @Override
    @Unique
    public int remorphed$getCounter(UUID skinId) {
        return this.remorphed$SkinMorphCounter.getOrDefault(skinId, 0);
    }

    @Override
    @Unique
    public void remorphed$handleSwap(ShapeType<? extends LivingEntity> type) {
        if (((Player)this).isCreative()) {
            return;
        }
        int counter = this.remorphed$getCounter(type) + 1;
        int killValue = Remorphed.getKillValue(type.getEntityType());
        if (killValue > 0 && counter >= killValue) {
            ServerPlayer serverPlayer;
            int k = this.remorphed$unlockedShapes.getOrDefault(type, 0);
            ShapeType killType = type;
            if (Walkers.CONFIG.unlockEveryVariant) {
                List variants = ShapeType.getAllTypes((EntityType)type.getEntityType(), (Level)this.level());
                for (int i = 0; k <= 0 && i < variants.size(); ++i) {
                    killType = (ShapeType)variants.get(i);
                    k = this.remorphed$unlockedShapes.getOrDefault(killType, 0);
                }
            }
            if (k <= 1) {
                int variants = this.remorphed$unlockedShapes.containsKey(killType) ? this.remorphed$unlockedShapes.remove(killType) : 0;
            } else {
                this.remorphed$unlockedShapes.put(killType, k - 1);
            }
            if (Walkers.CONFIG.unlockEveryVariant) {
                List variants = ShapeType.getAllTypes((EntityType)type.getEntityType(), (Level)this.level());
                for (int i = 0; counter > 0 && i < variants.size(); ++i) {
                    Integer c = this.remorphed$ShapeMorphCounter.remove(variants.get(i));
                    if (c == null) continue;
                    counter -= c.intValue();
                }
            } else {
                this.remorphed$ShapeMorphCounter.remove(type);
            }
            PlayerEntityMixin playerEntityMixin = this;
            if (playerEntityMixin instanceof ServerPlayer && !Remorphed.canUseShape((Player)(serverPlayer = (ServerPlayer)playerEntityMixin), type)) {
                PlayerShapeChanger.change2ndShape((ServerPlayer)serverPlayer, null);
            }
        } else {
            this.remorphed$ShapeMorphCounter.put(type, this.remorphed$ShapeMorphCounter.getOrDefault(type, 0) + 1);
        }
    }

    @Override
    @Unique
    public void remorphed$handleSwap(UUID skinId) {
        if (((Player)this).isCreative()) {
            return;
        }
        int counter = this.remorphed$SkinMorphCounter.getOrDefault(skinId, 0) + 1;
        int killValue = Remorphed.CONFIG.playerKillValue;
        if (killValue > 0 && ++counter >= killValue) {
            this.remorphed$SkinMorphCounter.remove(skinId);
            int k = this.remorphed$getKills(skinId) - 1;
            if (k <= 0) {
                this.remorphed$unlockedSkins.remove(skinId);
            } else {
                this.remorphed$unlockedSkins.put(skinId, k);
            }
        } else {
            this.remorphed$SkinMorphCounter.put(skinId, counter);
        }
    }

    @Override
    @Unique
    public Map<ShapeType<?>, Integer> remorphed$getShapeCounter() {
        return this.remorphed$ShapeMorphCounter;
    }

    @Override
    @Unique
    public Map<UUID, Integer> remorphed$getSkinCounter() {
        return this.remorphed$SkinMorphCounter;
    }
}

