/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.neoforge.mixin.client;

import dev.tocraft.remorphed.screen.render.GuiShapeRenderState;
import dev.tocraft.remorphed.screen.render.GuiShapeRenderer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.GuiRenderer;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={GuiRenderer.class})
public abstract class GuiRendererMixin {
    @Shadow
    @Final
    GuiRenderState renderState;
    @Shadow
    @Final
    private MultiBufferSource.BufferSource bufferSource;
    @Unique
    private final Map<Integer, GuiShapeRenderer> walkers$shapeRenderer = new HashMap<Integer, GuiShapeRenderer>();

    @Inject(method={"preparePictureInPictureState(Lnet/minecraft/client/gui/render/state/pip/PictureInPictureRenderState;IZ)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends PictureInPictureRenderState> void getShapeRenderer(PictureInPictureRenderState state, int guiScale, boolean firstPass, CallbackInfoReturnable<Boolean> cir) {
        if (state instanceof GuiShapeRenderState) {
            GuiShapeRenderState shapeState = (GuiShapeRenderState)state;
            GuiShapeRenderer renderer = this.walkers$shapeRenderer.computeIfAbsent(shapeState.id(), id -> new GuiShapeRenderer((int)id, this.bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()));
            renderer.prepare(shapeState, this.renderState, guiScale);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"close()V"}, at={@At(value="HEAD")})
    public void closeShapeRenderer(CallbackInfo ci) {
        this.walkers$shapeRenderer.values().forEach(PictureInPictureRenderer::close);
    }
}

