/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.network;

import com.mojang.authlib.GameProfile;
import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.permission.PermissionManager;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkHandler {
    public static final ResourceLocation MORPH_REQUEST = Remorphed.id("morph_request");
    public static final ResourceLocation UNLOCKED_SYNC = Remorphed.id("unlocked_sync");
    public static final ResourceLocation FAVORITE_SYNC = Remorphed.id("favorite_sync");
    public static final ResourceLocation FAVORITE_UPDATE = Remorphed.id("favorite_update");
    public static final ResourceLocation RESET_SKIN = Remorphed.id("reset_skin");
    public static final ResourceLocation PERMISSION_CHECK = Remorphed.id("permission_check");
    public static final ResourceLocation PERMISSION_RESPONSE = Remorphed.id("permission_response");
    public static final ResourceLocation DELETE_SHAPE = Remorphed.id("delete_shape");

    public static void registerPacketReceiver() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)MORPH_REQUEST, NetworkHandler::handleMorphRequestPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)FAVORITE_UPDATE, NetworkHandler::handleFavoriteRequestPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)RESET_SKIN, NetworkHandler::handleResetSkinPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)PERMISSION_CHECK, NetworkHandler::handlePermissionCheckPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)DELETE_SHAPE, NetworkHandler::handleDeleteShapePacket);
        ModernNetworking.registerType((ResourceLocation)UNLOCKED_SYNC);
        ModernNetworking.registerType((ResourceLocation)FAVORITE_SYNC);
        ModernNetworking.registerType((ResourceLocation)PERMISSION_RESPONSE);
    }

    private static void handleDeleteShapePacket(ModernNetworking.Context context, CompoundTag data) {
        boolean is_entity = data.getBoolean("is_entity").orElse(true);
        if (is_entity) {
            String id = (String)data.getString("id").orElseThrow();
            int v = data.getIntOr("variant", -1);
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(ResourceLocation.parse((String)id));
            PlayerMorph.handleSwap(context.getPlayer(), (ShapeType<? extends LivingEntity>)ShapeType.from((EntityType)type, (int)v));
        } else {
            String uuid = (String)data.getString("uuid").orElseThrow();
            PlayerMorph.handleSwap(context.getPlayer(), UUID.fromString(uuid));
        }
    }

    public static void sendDeleteShapePacket(ShapeType<?> type) {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("is_entity", true);
        compound.putString("id", EntityType.getKey((EntityType)type.getEntityType()).toString());
        compound.putInt("variant", type.getVariantData());
        ModernNetworking.sendToServer((ResourceLocation)DELETE_SHAPE, (CompoundTag)compound);
    }

    public static void sendDeleteShapePacket(UUID uuid) {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("is_entity", true);
        compound.putString("uuid", uuid.toString());
        ModernNetworking.sendToServer((ResourceLocation)DELETE_SHAPE, (CompoundTag)compound);
    }

    private static void handleResetSkinPacket(ModernNetworking.Context context, CompoundTag data) {
        if (Remorphed.foundSkinShifter) {
            SkinShifter.setSkin((ServerPlayer)((ServerPlayer)context.getPlayer()), null);
        }
    }

    private static void handlePermissionCheckPacket(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ModernNetworking.Context context, @NotNull CompoundTag tag) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        String permission = tag.getString("permission").orElse("");
        boolean hasPermission = !Remorphed.CONFIG.usePermissions || PermissionManager.hasPermission(player, permission);
        CompoundTag response = new CompoundTag();
        response.putString("permission", permission);
        response.putBoolean("hasPermission", hasPermission);
        ModernNetworking.sendToPlayer((ServerPlayer)player, (ResourceLocation)PERMISSION_RESPONSE, (CompoundTag)response);
    }

    public static void sendResetSkinPacket() {
        ModernNetworking.sendToServer((ResourceLocation)RESET_SKIN, (CompoundTag)new CompoundTag());
    }

    public static <T extends LivingEntity> void sendSwap2ndShapeRequest(@NotNull ShapeType<T> type) {
        CompoundTag compound = new CompoundTag();
        compound.putString("id", EntityType.getKey((EntityType)type.getEntityType()).toString());
        compound.putInt("variant", type.getVariantData());
        ModernNetworking.sendToServer((ResourceLocation)MORPH_REQUEST, (CompoundTag)compound);
    }

    public static <T extends LivingEntity> void sendSwapSkinRequest(@NotNull GameProfile playerProfile) {
        CompoundTag compound = new CompoundTag();
        compound.putIntArray("playerUUID", UUIDUtil.uuidToIntArray((UUID)playerProfile.getId()));
        ModernNetworking.sendToServer((ResourceLocation)MORPH_REQUEST, (CompoundTag)compound);
    }

    private static void handleMorphRequestPacket(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ModernNetworking.Context context, CompoundTag compound) {
        context.getPlayer().getServer().execute(() -> {
            if (Walkers.isPlayerBlacklisted((UUID)context.getPlayer().getUUID()) && Walkers.CONFIG.blacklistPreventsMorphing) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"walkers.player_blacklisted"), true);
                return;
            }
            if (compound.contains("playerUUID") && Remorphed.foundSkinShifter) {
                UUID targetSkinUUID = UUIDUtil.uuidFromIntArray((int[])((int[])compound.getIntArray("playerUUID").orElseThrow()));
                SkinShifter.setSkin((ServerPlayer)((ServerPlayer)context.getPlayer()), (UUID)targetSkinUUID);
                PlayerMorph.handleSwap(context.getPlayer(), targetSkinUUID);
            } else {
                ResourceLocation typeId = ResourceLocation.parse((String)((String)compound.getString("id").orElseThrow()));
                int typeVariant = compound.getIntOr("variant", -1);
                EntityType eType = BuiltInRegistries.ENTITY_TYPE.get(typeId).map(Holder::value).orElse(null);
                @Nullable ShapeType type = ShapeType.from((EntityType)eType, (int)typeVariant);
                boolean result = PlayerShapeChanger.change2ndShape((ServerPlayer)((ServerPlayer)context.getPlayer()), (ShapeType)type);
                if (result && type != null) {
                    PlayerShape.updateShapes((ServerPlayer)((ServerPlayer)context.getPlayer()), (LivingEntity)type.create(context.getPlayer().level(), context.getPlayer()));
                }
                context.getPlayer().refreshDimensions();
            }
        });
    }

    public static void sendFavoriteSync(ServerPlayer player) {
        Set<ShapeType<?>> favoriteShapes = PlayerMorph.getFavoriteShapes((Player)player);
        Set<UUID> favoriteSkins = PlayerMorph.getFavoriteSkinIds((Player)player);
        CompoundTag tag = new CompoundTag();
        ListTag shapeIdList = new ListTag();
        ListTag skinIdList = new ListTag();
        favoriteShapes.forEach(type -> shapeIdList.add((Object)type.writeCompound()));
        favoriteSkins.forEach(skin -> skinIdList.add((Object)new IntArrayTag(UUIDUtil.uuidToIntArray((UUID)skin))));
        tag.put("FavoriteShapes", (Tag)shapeIdList);
        tag.put("FavoriteSkins", (Tag)skinIdList);
        ModernNetworking.sendToPlayer((ServerPlayer)player, (ResourceLocation)FAVORITE_SYNC, (CompoundTag)tag);
    }

    public static void sendFavoriteRequest(@NotNull ShapeType<? extends LivingEntity> type, boolean favorite) {
        CompoundTag packet = new CompoundTag();
        packet.putString("id", EntityType.getKey((EntityType)type.getEntityType()).toString());
        packet.putInt("variant", type.getVariantData());
        packet.putBoolean("favorite", favorite);
        ModernNetworking.sendToServer((ResourceLocation)FAVORITE_UPDATE, (CompoundTag)packet);
    }

    public static void sendFavoriteRequest(@NotNull GameProfile playerProfile, boolean favorite) {
        CompoundTag packet = new CompoundTag();
        packet.putIntArray("playerUUID", UUIDUtil.uuidToIntArray((UUID)playerProfile.getId()));
        packet.putBoolean("favorite", favorite);
        ModernNetworking.sendToServer((ResourceLocation)FAVORITE_UPDATE, (CompoundTag)packet);
    }

    private static void handleFavoriteRequestPacket(ModernNetworking.Context context, @NotNull CompoundTag packet) {
        boolean favorite = packet.getBooleanOr("favorite", false);
        if (packet.contains("playerUUID")) {
            UUID skinId = UUIDUtil.uuidFromIntArray((int[])((int[])packet.getIntArray("playerUUID").orElseThrow()));
            context.getPlayer().getServer().execute(() -> {
                if (favorite) {
                    PlayerMorph.getFavoriteSkinIds(context.getPlayer()).add(skinId);
                } else {
                    PlayerMorph.getFavoriteSkinIds(context.getPlayer()).remove(skinId);
                }
                NetworkHandler.sendFavoriteSync((ServerPlayer)context.getPlayer());
            });
        } else {
            EntityType entityType = BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)((String)packet.getString("id").orElseThrow()))).map(Holder::value).orElse(null);
            int variant = packet.getIntOr("variant", -1);
            context.getPlayer().getServer().execute(() -> {
                @Nullable ShapeType type = ShapeType.from((EntityType)entityType, (int)variant);
                if (type != null) {
                    if (favorite) {
                        PlayerMorph.getFavoriteShapes(context.getPlayer()).add(type);
                    } else {
                        PlayerMorph.getFavoriteShapes(context.getPlayer()).remove(type);
                    }
                    NetworkHandler.sendFavoriteSync((ServerPlayer)context.getPlayer());
                }
            });
        }
    }
}

