/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.permission;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.tocraft.remorphed.permission.neoforge.PermissionManagerImpl;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class PermissionManager {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasPermission(@NotNull ServerPlayer player, @NotNull String permission) {
        void var1_1;
        return PermissionManagerImpl.hasPermission(player, (String)var1_1);
    }

    public static boolean canUseCommand(@NotNull ServerPlayer player, @NotNull String command) {
        return PermissionManager.hasPermission(player, "command." + command);
    }

    public static boolean canUseCommandOnSelf(@NotNull ServerPlayer player, @NotNull String command) {
        return PermissionManager.hasPermission(player, "command." + command + ".self") || PermissionManager.canUseCommand(player, command);
    }

    public static boolean canUseCommandOnOthers(@NotNull ServerPlayer player, @NotNull String command) {
        return PermissionManager.hasPermission(player, "command." + command + ".others") || PermissionManager.canUseCommand(player, command);
    }

    public static boolean canUseCommandOnTarget(@NotNull ServerPlayer executor, @NotNull ServerPlayer target, @NotNull String command) {
        if (executor.getUUID().equals(target.getUUID())) {
            return PermissionManager.canUseCommandOnSelf(executor, command);
        }
        return PermissionManager.canUseCommandOnOthers(executor, command);
    }

    public static boolean canMorphIntoType(@NotNull ServerPlayer player, @NotNull EntityType<?> entityType) {
        String entityKey = EntityType.getKey(entityType).toString();
        return PermissionManager.hasPermission(player, "type." + entityKey);
    }

    public static boolean canBypassTransformLock(@NotNull ServerPlayer player) {
        return PermissionManager.hasPermission(player, "bypass.lock");
    }

    public static boolean canMorph(@NotNull ServerPlayer player) {
        return PermissionManager.hasPermission(player, "morph");
    }
}

