/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen;

import dev.tocraft.craftedcore.gui.LongTextWidget;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.screen.RemorphedMenu;
import dev.tocraft.walkers.WalkersClient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class RemorphedHelpScreen
extends Screen {
    public final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    @Nullable
    protected LongTextWidget list;

    public RemorphedHelpScreen() {
        super((Component)Component.literal((String)"REMORPHED"));
    }

    protected void init() {
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void addTitle() {
        this.layout.addTitleHeader(this.title, this.font);
    }

    protected void addContents() {
        this.list = (LongTextWidget)this.layout.addToContents((LayoutElement)new LongTextWidget(0, this.layout.getHeaderHeight(), this.width, this.layout.getContentHeight(), true, Remorphed.CONFIG.row_width));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.welcome"));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.credits").append("\n"));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.deleting_shapes_label").withStyle(ChatFormatting.BOLD));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.deleting_shapes_description").append("\n"));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.variants_label").withStyle(ChatFormatting.BOLD));
        Component keyStr = WalkersClient.VARIANTS_MENU_KEY.getTranslatedKeyMessage();
        this.list.addText((Component)Component.translatable((String)"remorphed.help.variants_description", (Object[])new Object[]{keyStr, keyStr}).append("\n"));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.ability_label").withStyle(ChatFormatting.BOLD));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.ability_description_1"));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.ability_description_2"));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.ability_description_3").append("\n"));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.config_label").withStyle(ChatFormatting.BOLD));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.config_description").append("\n"));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.support_label").withStyle(ChatFormatting.BOLD));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.support_description").append("\n"));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.credits_label").withStyle(ChatFormatting.BOLD));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.credits_general"));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.credits_translators").append("\n"));
        this.list.addText((Component)Component.translatable((String)"remorphed.help.return").withStyle(ChatFormatting.ITALIC));
    }

    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> Minecraft.getInstance().setScreen((Screen)new RemorphedMenu())).width(200).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode < 257 && keyCode != 32) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.list != null) {
            this.list.updateSize(this.width, this.layout);
        }
    }
}

