/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Window;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.impl.FakeClientPlayer;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.mixin.client.accessor.ScreenAccessor;
import dev.tocraft.remorphed.screen.RemorphedHelpScreen;
import dev.tocraft.remorphed.screen.widget.EntityWidget;
import dev.tocraft.remorphed.screen.widget.PlayerWidget;
import dev.tocraft.remorphed.screen.widget.SearchWidget;
import dev.tocraft.remorphed.screen.widget.ShapeListWidget;
import dev.tocraft.remorphed.screen.widget.ShapeWidget;
import dev.tocraft.remorphed.screen.widget.SkinWidget;
import dev.tocraft.remorphed.screen.widget.SpecialShapeWidget;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class RemorphedMenu
extends Screen {
    @Nullable
    protected ShapeListWidget list;
    public final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private static String lastSearchContents = "";
    private final List<ShapeType<?>> unlockedShapes = new CopyOnWriteArrayList();
    private final List<GameProfile> unlockedSkins = new CopyOnWriteArrayList<GameProfile>();
    private final Map<ShapeType<?>, Mob> renderEntities = new ConcurrentHashMap();
    private final Map<GameProfile, FakeClientPlayer> renderPlayers = new ConcurrentHashMap<GameProfile, FakeClientPlayer>();
    private final SearchWidget searchBar = this.createSearchBar();
    private final Button helpButton = this.createHelpButton();
    private final PlayerWidget playerButton = this.createPlayerButton();
    private final SpecialShapeWidget specialShapeButton = this.createSpecialShapeButton();
    private final Button traitsButton = this.createTraitsButton();

    public RemorphedMenu() {
        super((Component)Component.literal((String)"ReMorphed Menu"));
    }

    protected void init() {
        this.addHeader();
        this.addContents();
        this.addFooter();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void addHeader() {
        LinearLayout linearLayout = ((LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.horizontal())).spacing(8);
        linearLayout.addChild((LayoutElement)this.traitsButton);
        linearLayout.addChild((LayoutElement)this.searchBar);
        linearLayout.addChild((LayoutElement)this.helpButton);
        linearLayout.addChild((LayoutElement)this.playerButton);
        if (this.minecraft != null && this.minecraft.player != null && Walkers.hasSpecialShape((UUID)this.minecraft.player.getUUID())) {
            linearLayout.addChild((LayoutElement)this.specialShapeButton);
        }
    }

    protected void addContents() {
        this.list = (ShapeListWidget)this.layout.addToContents((LayoutElement)new ShapeListWidget(this.minecraft, this.width, this.layout));
        if (this.minecraft != null && this.minecraft.player != null) {
            this.populateUnlockedRenderEntities((Player)this.minecraft.player);
            ShapeType currentShape = ShapeType.from((LivingEntity)PlayerShape.getCurrentShape((Player)this.minecraft.player));
            this.unlockedShapes.sort((first, second) -> {
                boolean secondIsFav;
                boolean firstIsFav;
                if (Remorphed.CONFIG.sort_selected) {
                    if (Objects.equals(first, currentShape)) {
                        return -1;
                    }
                    if (Objects.equals(second, currentShape)) {
                        return 1;
                    }
                }
                if ((firstIsFav = PlayerMorph.getFavoriteShapes((Player)this.minecraft.player).contains(first)) == (secondIsFav = PlayerMorph.getFavoriteShapes((Player)this.minecraft.player).contains(second))) {
                    return 0;
                }
                if (firstIsFav) {
                    return -1;
                }
                return 1;
            });
            ArrayList newUnlocked = new ArrayList();
            for (ShapeType<?> shapeType : this.unlockedShapes) {
                if (newUnlocked.stream().map(ShapeType::getEntityType).toList().contains(shapeType.getEntityType()) || currentShape != null && !shapeType.equals((Object)currentShape) && shapeType.getEntityType() == currentShape.getEntityType() && shapeType.getVariantData() != currentShape.getVariantData()) continue;
                newUnlocked.add(shapeType);
            }
            this.unlockedShapes.clear();
            this.unlockedShapes.addAll(newUnlocked);
            if (Remorphed.foundSkinShifter) {
                this.populateUnlockedRenderPlayers((Player)this.minecraft.player);
                UUID currentSkin = SkinShifter.getCurrentSkin((Player)this.minecraft.player);
                this.unlockedSkins.sort((first, second) -> {
                    boolean secondIsFav;
                    if (Objects.equals(first.getId(), currentSkin) && currentShape != null) {
                        return -1;
                    }
                    if (Objects.equals(second.getId(), currentSkin) && currentShape != null) {
                        return 1;
                    }
                    boolean firstIsFav = PlayerMorph.getFavoriteSkinIds((Player)this.minecraft.player).contains(first.getId());
                    if (firstIsFav == (secondIsFav = PlayerMorph.getFavoriteSkinIds((Player)this.minecraft.player).contains(second.getId()))) {
                        return first.getName().compareTo(second.getName());
                    }
                    if (firstIsFav) {
                        return -1;
                    }
                    return 1;
                });
            }
        }
        this.searchBar.setResponder(text -> {
            ((ScreenAccessor)((Object)this)).getNarratables().removeIf(button -> button instanceof EntityWidget);
            this.children().removeIf(button -> button instanceof EntityWidget);
            List<ShapeType<?>> filteredShapes = this.unlockedShapes.stream().filter(type -> text.isEmpty() || ShapeType.createTooltipText((LivingEntity)this.renderEntities.get(type)).getString().toUpperCase().contains(text.toUpperCase()) || EntityType.getKey((EntityType)type.getEntityType()).toString().toUpperCase().contains(text.toUpperCase())).toList();
            List<GameProfile> filteredSkins = this.unlockedSkins.stream().filter(skin -> text.isEmpty() || skin.getName().toUpperCase().contains(text.toUpperCase()) || skin.getId().toString().contains(text.toUpperCase())).toList();
            this.populateShapeWidgets(filteredShapes, filteredSkins);
            Remorphed.LOGGER.info("Loaded {} entities and {} skins for rendering", (Object)filteredShapes.size(), (Object)filteredSkins.size());
            lastSearchContents = text;
        });
        this.searchBar.insertText(lastSearchContents);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void populateShapeWidgets(@NotNull List<ShapeType<?>> rendered, @NotNull List<GameProfile> skinProfiles) {
        if (this.list != null && this.minecraft != null && this.minecraft.player != null) {
            this.list.clearEntries();
            int rows = (int)Math.ceil((float)(rendered.size() + skinProfiles.size()) / (float)Remorphed.CONFIG.shapes_per_row);
            ShapeType currentType = ShapeType.from((LivingEntity)PlayerShape.getCurrentShape((Player)this.minecraft.player));
            int currentRow = 0;
            for (int i = 0; i <= rows; ++i) {
                ArrayList<ShapeWidget> row = new ArrayList<ShapeWidget>();
                for (int j = 0; j < Remorphed.CONFIG.shapes_per_row; ++j) {
                    boolean bl;
                    int listIndex = i * Remorphed.CONFIG.shapes_per_row + j;
                    if (Remorphed.foundSkinShifter && listIndex < skinProfiles.size()) {
                        GameProfile skinProfile = skinProfiles.get(listIndex);
                        AbstractClientPlayer fakePlayer = this.renderPlayers.get(skinProfile);
                        if (fakePlayer != null) {
                            boolean bl2 = bl = Objects.equals(SkinShifter.getCurrentSkin((Player)this.minecraft.player), skinProfile.getId()) && currentType == null;
                            if (bl) {
                                currentRow = i;
                            }
                            row.add(new SkinWidget(0, 0, 0, 0, skinProfile, new FakeClientPlayer(this.minecraft.level, skinProfile), this, PlayerMorph.getFavoriteSkins((Player)this.minecraft.player).contains(skinProfile), bl, Remorphed.canUseEveryShape((Player)this.minecraft.player) || Remorphed.CONFIG.playerKillValue < 1 ? -1 : Remorphed.CONFIG.playerKillValue * PlayerMorph.getPlayerKills((Player)this.minecraft.player, skinProfile.getId()) - PlayerMorph.getCounter((Player)this.minecraft.player, skinProfile.getId())));
                            continue;
                        }
                        Remorphed.LOGGER.error("invalid skin profile: {}", (Object)skinProfile);
                        continue;
                    }
                    if (listIndex >= skinProfiles.size() + rendered.size()) continue;
                    ShapeType<?> type = rendered.get(listIndex - skinProfiles.size());
                    Mob entity = this.renderEntities.get(type);
                    if (entity != null) {
                        bl = type.equals((Object)currentType);
                        if (bl) {
                            currentRow = i;
                        }
                        row.add(new EntityWidget<Mob>(i * Remorphed.CONFIG.shapes_per_row + j, 0, 0, 0, 0, type, entity, this, PlayerMorph.getFavoriteShapes((Player)this.minecraft.player).contains(type), bl, Remorphed.canUseEveryShape((Player)this.minecraft.player) || Remorphed.getKillValue(type.getEntityType()) < 1 ? -1 : Remorphed.getKillValue(type.getEntityType()) * PlayerMorph.getKills((Player)this.minecraft.player, type) - PlayerMorph.getCounter((Player)this.minecraft.player, type)));
                        continue;
                    }
                    Remorphed.LOGGER.error("invalid shape type: {}", (Object)type.getEntityType().getDescriptionId());
                }
                this.list.addRow((ShapeWidget[])row.toArray(ShapeWidget[]::new));
            }
            if (Remorphed.CONFIG.focus_selected) {
                this.list.setScrollAmount((double)this.list.rowHeight() * (double)(currentRow - 2));
            }
        }
    }

    public synchronized void populateUnlockedRenderEntities(Player player) {
        this.unlockedShapes.clear();
        this.renderEntities.clear();
        List<ShapeType<?>> validUnlocked = Remorphed.getUnlockedShapes(player);
        for (ShapeType<?> type : validUnlocked) {
            LivingEntity entity = type.create((Level)Minecraft.getInstance().level, player);
            if (!(entity instanceof Mob)) continue;
            Mob living = (Mob)entity;
            this.unlockedShapes.add(type);
            this.renderEntities.put(type, living);
        }
    }

    public synchronized void populateUnlockedRenderPlayers(Player player) {
        this.unlockedSkins.clear();
        this.renderPlayers.clear();
        List<GameProfile> validUnlocked = Remorphed.getUnlockedSkins(player);
        for (GameProfile profile : validUnlocked) {
            if (profile.getId() == player.getUUID()) continue;
            FakeClientPlayer entity = null;
            if (this.minecraft != null) {
                entity = new FakeClientPlayer(this.minecraft.level, profile);
            }
            this.unlockedSkins.add(profile);
            this.renderPlayers.put(profile, entity);
        }
    }

    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(200).build());
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.list != null) {
            this.list.updateSize(this.width, this.layout);
        }
    }

    @Contract(value=" -> new")
    @NotNull
    private SearchWidget createSearchBar() {
        return new SearchWidget(0.0f, 0.0f, (float)this.getWindow().getGuiScaledWidth() / 4.0f, 20.0f);
    }

    @NotNull
    private Button createHelpButton() {
        Button.Builder helpButton = Button.builder((Component)Component.nullToEmpty((String)"?"), widget -> Minecraft.getInstance().setScreen((Screen)new RemorphedHelpScreen()));
        helpButton.size(20, 20);
        helpButton.tooltip(Tooltip.create((Component)Component.translatable((String)"remorphed.help")));
        return helpButton.build();
    }

    @NotNull
    private Button createTraitsButton() {
        MutableComponent text = Component.translatable((String)"remorphed.show_traits");
        Button.Builder traitButton = Button.builder((Component)text, widget -> {
            Remorphed.displayDataInMenu = !Remorphed.displayDataInMenu;
        });
        traitButton.size(Minecraft.getInstance().font.width(text.getString()) + 20, 20);
        traitButton.tooltip(Tooltip.create((Component)Component.translatable((String)"remorphed.traits")));
        return traitButton.build();
    }

    @Contract(value=" -> new")
    @NotNull
    private PlayerWidget createPlayerButton() {
        return new PlayerWidget(0, 0, 20, 20, this);
    }

    @Contract(value=" -> new")
    @NotNull
    private SpecialShapeWidget createSpecialShapeButton() {
        return new SpecialShapeWidget(0, 0, 20, 20, this);
    }

    @NotNull
    private Window getWindow() {
        return Minecraft.getInstance().getWindow();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (GuiEventListener child : this.children()) {
            if (!child.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

