/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tocraft.remorphed.screen.render.GuiShapeRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class GuiShapeRenderer
extends PictureInPictureRenderer<GuiShapeRenderState> {
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final int id;

    public GuiShapeRenderer(int id, MultiBufferSource.BufferSource bufferSource, EntityRenderDispatcher entityRenderDispatcher) {
        super(bufferSource);
        this.entityRenderDispatcher = entityRenderDispatcher;
        this.id = id;
    }

    @NotNull
    public Class<GuiShapeRenderState> getRenderStateClass() {
        return GuiShapeRenderState.class;
    }

    protected void renderToTexture(@NotNull GuiShapeRenderState state, @NotNull PoseStack poseStack) {
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        Vector3f vector3f = state.translation();
        poseStack.translate(vector3f.x, vector3f.y, vector3f.z);
        poseStack.mulPose((Quaternionfc)state.rotation());
        Quaternionf quaternionf = state.overrideCameraAngle();
        if (quaternionf != null) {
            this.entityRenderDispatcher.overrideCameraOrientation(quaternionf.conjugate(new Quaternionf()).rotateY((float)Math.PI));
        }
        this.entityRenderDispatcher.setRenderShadow(false);
        this.entityRenderDispatcher.render(state.renderState(), 0.0, 0.0, 0.0, poseStack, (MultiBufferSource)this.bufferSource, 0xF000F0);
        this.entityRenderDispatcher.setRenderShadow(true);
    }

    protected float getTranslateY(int height, int guiScale) {
        return (float)height / 2.0f;
    }

    @NotNull
    protected String getTextureLabel() {
        return String.format("walkers: entity %s", this.id);
    }
}

