/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.RemorphedClient;
import dev.tocraft.remorphed.network.NetworkHandler;
import dev.tocraft.remorphed.screen.widget.ShapeWidget;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.traits.ShapeTrait;
import dev.tocraft.walkers.traits.TraitRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class EntityWidget<T extends LivingEntity>
extends ShapeWidget {
    private final ShapeType<T> type;
    private final T entity;
    private final int size;
    private final int id;

    public EntityWidget(int id, int x, int y, int width, int height, ShapeType<T> type, @NotNull T entity, Screen parent, boolean isFavorite, boolean current, int availability) {
        super(x, y, width, height, parent, isFavorite, current, availability);
        this.size = (int)((float)Remorphed.CONFIG.entity_size * (1.0f / Math.max(entity.getBbHeight(), entity.getBbWidth())));
        this.type = type;
        this.entity = entity;
        this.id = id;
        entity.setGlowingTag(true);
        this.setTooltip(Tooltip.create((Component)ShapeType.createTooltipText(entity)));
    }

    @Override
    protected void sendFavoriteRequest(boolean isFavorite) {
        NetworkHandler.sendFavoriteRequest(this.type, isFavorite);
    }

    @Override
    protected void sendSwap2ndShapeRequest() {
        NetworkHandler.sendSwap2ndShapeRequest(this.type);
    }

    @Override
    protected void renderShape(GuiGraphics guiGraphics) {
        if (Remorphed.displayDataInMenu) {
            int iconS = 16;
            int row = 0;
            int column = 0;
            ArrayList<ResourceLocation> renderedTraits = new ArrayList<ResourceLocation>();
            List traits = TraitRegistry.getAll(this.entity);
            for (ShapeTrait trait : traits) {
                boolean bl;
                if (trait == null || renderedTraits.contains(trait.getId()) && !trait.iconMightDiffer() || !(bl = trait.renderIcon(RenderPipelines.GUI_TEXTURED, guiGraphics, this.getX() + column, this.getY() + row, 16, 16))) continue;
                if (row + 16 >= this.getHeight()) {
                    column += 16;
                    row = 0;
                } else {
                    row += 16;
                }
                if (column + 16 >= this.getWidth()) break;
                renderedTraits.add(trait.getId());
            }
        }
        try {
            int leftPos = (int)((float)this.getX() + (float)this.getWidth() / 2.0f);
            int topPos = (int)((float)this.getY() + (float)this.getHeight() * 0.75f);
            int k = leftPos - 20;
            int l = topPos - 25;
            int m = leftPos + 20;
            int n = topPos + 35;
            RemorphedClient.renderEntityInInventory(this.id, guiGraphics, k, l, m, n, this.size, new Vector3f(), new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, this.entity);
        }
        catch (Exception e) {
            Remorphed.LOGGER.error("Error while rendering {}", (Object)ShapeType.createTooltipText(this.entity).getString(), (Object)e);
            this.setCrashed();
            MultiBufferSource.BufferSource immediate = Minecraft.getInstance().renderBuffers().bufferSource();
            immediate.endBatch();
            EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            entityRenderDispatcher.setRenderShadow(true);
            RenderSystem.getModelViewStack().popMatrix();
        }
    }

    @Override
    void sendDeleteShapePacket() {
        NetworkHandler.sendDeleteShapePacket(this.type);
    }
}

