/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen.widget;

import com.mojang.authlib.GameProfile;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.impl.FakeClientPlayer;
import dev.tocraft.remorphed.network.NetworkHandler;
import dev.tocraft.remorphed.screen.widget.ShapeWidget;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.network.impl.SwapPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class SkinWidget
extends ShapeWidget {
    private final GameProfile skin;
    private final FakeClientPlayer fakePlayer;
    private final int size;

    public SkinWidget(int x, int y, int width, int height, @NotNull GameProfile skin, @NotNull FakeClientPlayer fakePlayer, Screen parent, boolean isFavorite, boolean isCurrent, int availability) {
        super(x, y, width, height, parent, isFavorite, isCurrent, availability);
        this.size = (int)((float)Remorphed.CONFIG.entity_size * (1.0f / Math.max(fakePlayer.getBbHeight(), fakePlayer.getBbWidth())));
        this.skin = skin;
        this.fakePlayer = fakePlayer;
        this.setTooltip(Tooltip.create((Component)Component.literal((String)skin.getName())));
    }

    @Override
    protected void sendFavoriteRequest(boolean isFavorite) {
        NetworkHandler.sendFavoriteRequest(this.skin, isFavorite);
    }

    @Override
    protected void sendSwap2ndShapeRequest() {
        NetworkHandler.sendSwapSkinRequest(this.skin);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && PlayerShape.getCurrentShape((Player)player) != null) {
            SwapPackets.sendSwapRequest();
        }
    }

    @Override
    protected void renderShape(GuiGraphics guiGraphics) {
        if (this.skin != null) {
            int leftPos = (int)((float)this.getX() + (float)this.getWidth() / 2.0f);
            int topPos = (int)((float)this.getY() + (float)this.getHeight() * 0.75f);
            int k = leftPos - 20;
            int l = topPos - 25;
            int m = leftPos + 20;
            int n = topPos + 35;
            InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)k, (int)l, (int)m, (int)n, (float)this.size, (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, (LivingEntity)this.fakePlayer);
        }
    }

    @Override
    void sendDeleteShapePacket() {
        NetworkHandler.sendDeleteShapePacket(this.skin.getId());
    }
}

